/**
 * DEMO 
 */

// Visual C workarounds
#ifdef _MSC_VER
#define M_PI 3.14159265352
#include <windows.h>
#endif

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <cmath>
#include <cstdlib>
#include <iostream>
#include <vector>

#include "graphics.hpp"
#include "utils.hpp"

#include "background.hpp"
#include "background2.hpp"
#include "font.hpp"
#include "scroller.hpp"

#include <fmod.h>
#include <fmod_errors.h>

/** Set to 1 to enable full screen mode */
const int FULLSCREEN = 1;

/** Set to 1 to disable sound playback */
const int NO_SOUND = 0;

#define WIDTH 640
#define HEIGHT 480

/** Reference to the FMOD music */
FMUSIC_MODULE *mod = NULL;

double _START = 0.0;

/**
 * Gets the current time in SDL ticks.
 */
float getTime() {
  return SDL_GetTicks() / 1000.0f - _START;
  //  return FMUSIC_GetTime(mod) / 1000.0f;
}

void  resetTimer() {
  _START = SDL_GetTicks() / 1000.0f;
}

void coppers();
/**
 * Initializes SDL (Simple Direct media Layer)
 */
void init_sdl() {
  SDL_Init(SDL_INIT_VIDEO);
  SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 8);
  SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 8);
  SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 8);
  SDL_GL_SetAttribute(SDL_GL_ALPHA_SIZE, 8);
  SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 24);
  SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);

#ifdef SDL_1_2_10
  SDL_GL_SetAttribute(SDL_GL_SWAP_CONTROL, 1);
#endif /* SDL_1_2_10 */
  SDL_ShowCursor(0);
  
  SDL_Surface *screen = 0;
  
  if ((screen=SDL_SetVideoMode(WIDTH, HEIGHT, 0, SDL_OPENGL | (FULLSCREEN ? SDL_FULLSCREEN : 0) )) == 0) {
    dprintf("Could not initialize SDL/OpenGL: %s\n", SDL_GetError());
    SDL_Quit();
    return;
  }

#ifdef _MSC_VER
  ShowCursor(0);
#endif
}

/**
 * Initializes OpenGL
 */
void init_opengl() {
  glShadeModel(GL_SMOOTH);
  glClearDepth(1.0f);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(45.0f, (double) WIDTH / HEIGHT, 0.1f, 100.0f);
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();

  set_gl_lighting();
}

/**
 * Initializes FMOD and starts playing the specified music file.
 * @param file the filename of the music to play, typically "chip.xm"
 */
void init_fmod(char* file) {
  dprintf("Initializing music...\n");
  
  if (FSOUND_GetVersion() < FMOD_VERSION) {
    dprintf("Error: You are using the wrong DLL version!  You should be using FMOD %.02f\n", FMOD_VERSION);
    exit(1);
  }

  if (NO_SOUND) {
    FSOUND_SetOutput(FSOUND_OUTPUT_NOSOUND);
  }
  
  if (!FSOUND_Init(44100, 32, 0)) {
    dprintf("FMOD init error: %s\n", FMOD_ErrorString(FSOUND_GetError()));
    exit(1);
  }

  mod = FMUSIC_LoadSong(file);
  if (!mod) {
    dprintf("FMOD load error: %s\n", FMOD_ErrorString(FSOUND_GetError()));
    exit(1);
  }

  FMUSIC_SetLooping(mod, 1);
  FMUSIC_PlaySong(mod);     
}

void fadeout(double alpha, double color) {
  float fade = 1.0-alpha;
  if (fade<0.0)
    fade = 0.0;
  if (fade>1.0)
    fade = 1.0;
  FMUSIC_SetMasterVolume( mod, int(fade*255) );

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -1.0);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0, 640.0, 480.0, 0.0, 0.0, 1000);

  glDisable(GL_LIGHTING);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glDisable(GL_TEXTURE_2D);

  glDisable(GL_LIGHTING);
  glColor4f(color, color, color, alpha);
  glBegin(GL_QUADS);
  glVertex3f(0.0, 0.0, 0.0);
  glVertex3f(640.0, 0.0, 0.0);
  glVertex3f(640.0, 480.0, 0.0);
  glVertex3f(0.0, 480.0, 0.0);
  glEnd();

  glPopMatrix();
  glPopMatrix();
}


/**
 * Display nice stuffs.
 */
void effects() {
  bool quit = false;
  SDL_Event event;

  Background background;
  Background2 gabber;
  Scroller s(3);

  double start_time = getTime();
  int frames = 0;
  int prev_pattern = -1;
  while (!quit) {

    char title[255];
    sprintf(title,"%f", getTime());

       SDL_WM_SetCaption(title, 0 );

    glPushAttrib(~0);

    frames++;

	int prev_pos;
	int next_pos;
    
    while(SDL_PollEvent(&event)){ 
      switch(event.type){ 
      case SDL_KEYDOWN:
	switch (event.key.keysym.sym) {
	case SDLK_LEFT:
	  prev_pos = FMUSIC_GetOrder(mod) - 1;
	  FMUSIC_SetOrder(mod, prev_pos);
	  break;
	case SDLK_RIGHT:
	  next_pos = FMUSIC_GetOrder(mod) + 1;
	  FMUSIC_SetOrder(mod, next_pos);
	  break;
	case SDLK_ESCAPE:
	  quit = true;
	  break;
	default:
	  // Other keys not handled
	  break;
	}
      }
    }

    int pattern = FMUSIC_GetOrder(mod);
    int row = FMUSIC_GetRow(mod);

    if (prev_pattern != pattern) {
      dprintf("pattern = %d\n", pattern);
    }
    prev_pattern = pattern;

    reset_gl();

    //    glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
    glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);

//     /* font */
//     if ((pattern >= 0) && (pattern <= 2)) {
//       scroller.effect(getTime());
//     }

    /* copper bars */
    coppers();

    set_gl_lighting();
    reset_gl();
    background.effect(getTime(), pattern);


    int twitch = ((row - 2) % 8) == 1;
    if (pattern == 1) {
      twitch = 0;
    }

    gabber.effect(getTime(), 1-twitch);
    s.draw4(getTime());

    // FADEOUT ALS HET ZAT IS XXX
    if (getTime() > 18.5) {
      static double start = getTime();
      fadeout((getTime() - start) / 5.0, 0.0);
      if (getTime() - start > 6.0) {
        quit = 1;
      }
    }

    /* the end */
    if ((pattern == 16) && (row == 31)) {
      break;
    }

    
//     for (int i = 0; i < 100000; i++) {
//       getTime();
//    }
//     glFlush();
//     glFinish();
    SDL_GL_SwapBuffers();
    glPopAttrib();
  }
  dprintf("FPS = %f\n", frames / (getTime() - start_time));
}

void cop(double start, int flag) {
  int width = 640;
  int height = 40;
  glBegin(GL_QUADS);

  for (int i = 0; i < height;i++) {
    double y = start + i;
    double f = sin((double) i / height * 1.0 * M_PI) / 2.0 + 0.5;
    f = f * f * f;
//     if (getTime() > 13.0) {
//       f = f * (15.0 - getTime()) / 2.0;
//     }
    double alpha = 1.0;
    if (flag == 1) {
      glColor4f(f, 0, 0, alpha);
    }
    if (flag == 2) {
      glColor4f(f, f, f, alpha);
    }
    if (flag == 3) {
      glColor4f(0, 0, f, alpha);
    }
    glVertex3f(0.0, y, 0.0);
    glVertex3f(width, y, 0.0);
    glVertex3f(width, y + 1.0, 0.0);
    glVertex3f(0.0, y + 1.0, 0.0);
  }
  glEnd();
}

void cop2(double start, double offset, int flag) {
  double paard = 1.0;

  int width = 32.0 * paard;
  int height = 480 - start;
  glDisable(GL_TEXTURE_2D);
  glDisable(GL_TEXTURE);
  glDisable(GL_BLEND);
  glDisable(GL_LIGHTING);
  glBegin(GL_QUADS);

  offset -= width / 2.0;

  for (int i = 0; i < width; i+=paard) {
    double y = start;
    double f = sin((double) i / width * 1.0 * M_PI) / 2.0 + 0.5;
    f = f * f * f;
//     if (getTime() > 13.0) {
//       f = f * (15.0 - getTime()) / 2.0;
//     }
    if (flag == 1) {
      glColor3f(f * 0.9, f * 0.5, f * 0.7);
    }
    if (flag == 2) {
      glColor3f(f, f, f);
    }
    if (flag == 3) {
      glColor3f(f, 0, 0);
    }
    if (flag == 4) {
      glColor3f(f, f, 0);
    }

    double less = 0.5;
    glColor3f(less * f, less * 0.5 * f, less * 0);

    glVertex3f(offset + i, y, 0.0);
    glVertex3f(offset + paard + i, y, 0.0);
    glVertex3f(offset + paard + i, y + 1.0, 0.0);
    glVertex3f(offset + i, y + 1.0, 0.0);

    glColor3f(f, 0.5 * f, 0);
    glVertex3f(offset + i, y + 1.0, 0.0);
    glVertex3f(offset + paard + i, y + 1.0, 0.0);
    glVertex3f(offset + paard + i, 480.0, 0.0);
    glVertex3f(offset + i, 480.0, 0.0);
  }
  glEnd();
}

double volume(int channel) {
  float min, max;
  FSOUND_GetCurrentLevels(channel, &min, &max);
  return (max + min ) / 2.0;
}

void coppers() {

  double time = getTime();

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -1.0);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0, 640.0, 480.0, 0.0, 0.0, 1000);
  glDisable(GL_LIGHTING);

  // second
  for (int i = 0; i < 480; i+=6) {
    double x1 = 320.0 + sin(-time * 2.0 + i / 70.0) * 300.0;
    double y1 = i;
    cop2(y1, x1, 1);
//     double x2 = 320.0 + sin(time * 2.0 + i / 70.0) * 300.0;
//     double y2 = i;
//     cop2(y2, x2, 1);
  }

  // first
  double start1 = 240.0 + sin(time * 2.0 + 0.0) * 200.0;

  cop(start1, 1);
  // 2nd
  double start2 = 240.0 + sin(time * 2.0 + 0.2) * 200.0;
  cop(start2, 2);
  // 3
  double start3 = 240.0 + sin(time * 2.0 + 0.4) * 200.0;
  cop(start3, 3);

  glPopMatrix();

  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

}

void intero() {
  SDL_Event event;
  int quit = 0;
  Scroller s(3);
  Background background;


  do { 
    glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
      while(SDL_PollEvent(&event)){ 
         switch(event.type){ 
         case SDL_KEYDOWN:
           switch (event.key.keysym.sym) {
        case SDLK_ESCAPE:
          quit = true;
          break;
        default:
          // Other keys not handled
          break;
        }
      }
    }
    glPushAttrib(~0);
//     coppers();
//     s.draw4(getTime());
    background.effect(getTime(), 0);

    SDL_GL_SwapBuffers();
    glPopAttrib();
  } while ((getTime() < 15.0) && (!quit));
}

/**
 * Main routine
 */
int main(int argc, char *argv[]) {
  init_sdl();
  init_opengl();

  if (FULLSCREEN) {
    while (getTime() < 1.0) {
    }
  }

//   intero();

  resetTimer();
  init_fmod("floepflap.xm");
   FMUSIC_SetOrder(mod, 1);

  effects();
  SDL_Quit();

  return 0;
}
