#include <GL/gl.h>
#include <GL/glu.h>

#include <cstdlib>
#include <cmath>
#include <iostream>

#include "background2.hpp"
#include "graphics.hpp"

const char* GABBER_LOGO = "gabber.png";

#define WIDTH 512.0
#define HEIGHT 512.0

int stage;

Background2::Background2() {
  _textureId = load_texture_from_file(GABBER_LOGO, 0);
  _prev_stage = -1;
}

void Background2::effect(double time, int stage2) {
  if (_prev_stage != stage) {
    _prev_stage = stage;
    _t0 = time;
  }

  double local_time = time - _t0;

  _x_offset = 0.0;
  _y_offset = 0.0;

  stage = stage2;

  paint();
}

void Background2::paint() {
  glDisable(GL_LIGHTING);
  // TODO: This is too messy. Clean up.

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -1.0);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0, 320.0, 240.0, 0.0, 0.0, 1000);

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, _textureId);

  double z = 0.0;
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_SRC_ALPHA);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glColor4f(1.0,1.0,1.0,1.0);

  glBegin(GL_QUADS);
  glNormal3f(0.0, 0.0, 1.0);

  // draw background image


  int x0, y0, x1, y1;
  x0 = 111;
  y0 = 71;
  x1 = 175;
  y1 = 143;
  if (stage == 0) {
    x0 += 65;
    x1 += 65;
  }

  double tx0, ty0, tx1, ty1;
  tx0 = x0 / 512.0;
  ty0 = y0 / 512.0;
  tx1 = x1 / 512.0; 
  ty1 = y1 / 512.0; 

  //  int screenx = 320 - 64;
  int screenx = 10;
  int screeny = 240 - 68;
  double width  = x1 - x0;
  double height = y1 - y0;

  glColor3f(0.0, 0.0, 0.0);
  glTexCoord2f(tx0, ty0);
  glVertex3f(screenx, screeny, z);
  glTexCoord2f(tx1, ty0);
  glVertex3f(screenx + width, screeny, z);
  glTexCoord2f(tx1, ty1);
  glVertex3f(screenx + width, screeny + height, z);
  glTexCoord2f(tx0, ty1);
  glVertex3f(screenx,screeny + height, z);

  glColor4f(1.0, 1.0, 1.0, 1.0);
  screenx -= 3;
  screeny -= 3;
  glTexCoord2f(tx0, ty0);
  glVertex3f(screenx, screeny, z);
  glTexCoord2f(tx1, ty0);
  glVertex3f(screenx + width, screeny, z);
  glTexCoord2f(tx1, ty1);
  glVertex3f(screenx + width, screeny + height, z);
  glTexCoord2f(tx0, ty1);
  glVertex3f(screenx,screeny + height, z);

  glEnd();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();

  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  glColor3f(1.0, 1.0, 1.0);

  glEnable(GL_LIGHTING);
}

