#include <GL/gl.h>
#include <GL/glu.h>

#include <cstdlib>
#include <cmath>
#include <iostream>

#include "background.hpp"
#include "graphics.hpp"

const char* ECFH_LOGO = "limp.png";

#define WIDTH 512.0
#define HEIGHT 512.0

Background::Background() {
  _textureId = load_texture_from_file(ECFH_LOGO, 0);
  _prev_stage = -1;
}

void Background::effect(double time, int stage) {
  if (_prev_stage != stage) {
    _prev_stage = stage;
    _t0 = time;
  }

  double local_time = time - _t0;

  _x_offset = 0.0;
  _y_offset = 0.0;

  paint();
}

void Background::paint() {
  glDisable(GL_LIGHTING);
  // TODO: This is too messy. Clean up.

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  glTranslatef(0.0f, 0.0f, -1.0);

  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(0.0, 320.0, 240.0, 0.0, 0.0, 1000);

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, _textureId);

  double z = 0.0;
  glEnable(GL_BLEND);
  glBlendFunc(GL_ONE, GL_SRC_ALPHA);
  glDisable(GL_LIGHTING);
  glDisable(GL_DEPTH_TEST);
  glColor4f(1.0,1.0,1.0,1.0);

  glBegin(GL_QUADS);
  glNormal3f(0.0, 0.0, 1.0);

  // draw background image
  glTexCoord2f(0.0, 0.0);
  glVertex3f(_x_offset, _y_offset, z);
  glTexCoord2f(1.0, 0.0);
  glVertex3f(_x_offset + WIDTH, _y_offset, z);
  glTexCoord2f(1.0, 1.0);
  glVertex3f(_x_offset + WIDTH, _y_offset + HEIGHT, z);
  glTexCoord2f(0.0, 1.0);
  glVertex3f(_x_offset, _y_offset + HEIGHT, z);

  glEnd();

  glDisable(GL_TEXTURE_2D);
  glPopMatrix();

  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  glColor3f(1.0, 1.0, 1.0);

  glEnable(GL_LIGHTING);
}

