#include <boost/python.hpp>

#include "simplest.h"

using namespace boost::python;

BOOST_PYTHON_MODULE(libfmodwrapper)
{
  class_< fmodFFT >("FFT", init< >())
    .def( init< > ())
    .def( "updateSpectrum", &fmodFFT::updateSpectrum )
    .def( "getSpectralDensity", &fmodFFT::getSpectralDensity )
    .def( "getSmoothSpectralDensity", &fmodFFT::getSpectralDensity )
    ;

  class_< fmodSound >("Sound", init< >())
    .def( init< > ())
    .def( "play", &fmodSound::play )
    .def( "stop", &fmodSound::stop )
    .def( "getOrder", &fmodSound::getOrder )
    .def( "getMaxOrder", &fmodSound::getMaxOrder )
    .def( "setOrder", &fmodSound::setOrder )
    .def( "setInstCallback", &fmodSound::setInstCallback )
    ;

  class_< fmodStream >("Stream", init< >())
    .def( init< > ())
    .def( "play", &fmodStream::play )
    .def( "stop", &fmodStream::stop )
    .def( "getTime", &fmodStream::getTime )
    .def( "getLength", &fmodStream::getLength)
    .def( "seek", &fmodStream::seek )
    ;

  class_< fmodSystem >("System", init<bool>())
    .def( init<bool> ())
    .def( "createSound", &fmodSystem::createSound )
    .def( "createStream", &fmodSystem::createStream )
    .def( "update", &fmodSystem::update )
    ;

}
