from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from math import cos
import random

class TimeLine(Effect):
    """
    A simple effect that draws the timeline. Note that this is not made for esthetical reasons. Useful if you want to know what is going on.
    """

    def __init__(self):
        Effect.__init__(self)
        self.visible = False
        self._schedule = None
        self._markers = None

    def setSchedule(self, schedule):
        self._schedule = schedule

    def setMarkers(self, markers):
        self._markers = markers
    

    
    def draw(self, time, delta, start, stop):

#        if not self.visible:
#            return

        glDisable(GL_DEPTH_TEST)
        glDisable(GL_BLEND)
        glDisable(GL_TEXTURE_2D)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,1,0,.5,150)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        duration = 140.0
        barHeight = .02
        barTop = .02

        w = 1.0 / 512.0
        glTranslatef( 0.25 + -time * 1.0 / duration , 0.0, 0.0 )

        
        glBegin(GL_QUADS)

        

        colors = [[0,0.4,0.6],
                  [1,1,1]]



        lineNo = 0
        for line in self._schedule:
#            print "hoi"
            begin = line[0] / duration
            end = line[1] / duration
            glColor3f(0,0,0)
            glVertex2f(begin, barTop + lineNo * barHeight)
            glVertex2f(end,  barTop + lineNo * barHeight)


            glColor3f(*colors[lineNo % len(colors)])

            
            glVertex2f(end,  barTop + (lineNo + 1) * barHeight)
            glVertex2f(begin,  barTop +  (lineNo + 1) * barHeight)
            lineNo+=1
            
        glEnd()

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        # draw lines every 10 seconds
        glBegin(GL_LINES)
        glColor4f(0,1,0,.4)
        for i in xrange(int(duration / 10.0)):

            lineX = (i * 10.0) / duration
            glVertex2f(lineX, 0)
            glVertex2f(lineX, 1)

        glEnd()



        glBegin(GL_TRIANGLES)
        glColor(0.5,0.5,0.5,.8)
        markerNo = 0
        k = self._markers.keys()
        k.sort()
        
        for marker in k:
            yoff = barTop + lineNo * barHeight + (barHeight * (markerNo%2))
            lineX = marker / duration
            glColor(0.5,0.5,0.5,.8)
            glVertex2f(lineX-0.005, yoff+.015)
            glVertex2f(lineX+0.005, yoff+.015)
            glVertex2f(lineX, yoff)
            markerNo+=1
        glEnd()


        glEnable(GL_LINE_SMOOTH)
        glBegin(GL_LINES)
        glColor(0,1,0,1)
        yoff = barTop + lineNo * barHeight
        markerNo = 0
        for marker in k:
            yoff = barTop + lineNo * barHeight + (barHeight * (markerNo%2))
            lineX = marker / duration

            glVertex2f(lineX-0.005, yoff+.015)
            glVertex2f(lineX+0.005, yoff+.015)

            glVertex2f(lineX+0.005, yoff+.015)
            glVertex2f(lineX, yoff)

            glVertex2f(lineX, yoff)
            glVertex2f(lineX-0.005, yoff+.015)
            markerNo+=1
        glEnd()
        glDisable(GL_LINE_SMOOTH)




        lineX = time / duration
        glBegin(GL_LINES)
        glColor3f(0,1,0)
        glVertex2f(lineX, 0)
        glVertex2f(lineX, 1)
        glEnd()

        glDisable(GL_BLEND)
