from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import math
import random
import pygame
from core import TextureLoader 
from core import Texture
from core import GLSLShader

from effect import Effect

class textOverlay(Effect):

    def __init__(self):
        Effect.__init__(self)
        self.tex = {}
        pygame.font.init()
        f=pygame.font.Font( "data/gen4.ttf", 150 )

        #words = file("/usr/share/dict/words","r").readlines()
        self.timings = [
            (  8.71,  9.07, "IT'S"),
            (  9.07,  9.33, "LIMP"),
            (  9.33,  9.96, "NINJA"),
            ( 10.07, 10.34, "BACK"),
            ( 10.34, 10.47, "IN"),
            ( 10.47, 10.63, "THA"),
            ( 10.63, 11.17, "PLACE"),

            ( 20.22, 20.50, "COME"),
            ( 20.50, 20.65, "TO"),
            ( 20.64, 20.81, "CRASH"),
            ( 20.81, 20.99, "THA"),
            ( 20.99, 21.43, "PARTY"),
            ( 21.62, 21.88, "BLOOD"),
            ( 21.88, 22.03, "IN"),
            ( 22.03, 22.15, "YA"),
            ( 22.15, 23.05, "FACE"),

            ( 69.14, 69.17, "LOL"),

            (108.06,108.27, "GET"),
            (108.27,108.44, "THIS"),
            (108.44,108.72, "PARTY"),
            (108.72,109.20, "STARTED"),

            (135.6+ 10.07,135.6+ 10.34, "BACK"),
            (135.6+ 10.34,135.6+ 10.47, "IN"),
            (135.6+ 10.47,135.6+ 10.63, "THA"),
            (135.6+ 10.63,135.6+ 11.17, "PLACE"),

            (131.40,131.70, "CRASH"),
            (131.70,131.92, "THA"),
            (131.92,132.49, "PARTY"),

            (34.7+108.06,34.7+108.27, "GET"),
            (34.7+108.27,34.7+108.44, "THIS"),
            (34.7+108.44,34.7+108.72, "PARTY"),
            (34.7+108.72,34.7+109.20, "STARTED"),
            
            (154.11,154.51, "  4  "),
            (154.51,154.86, "  3  "),
            (154.86,155.24, "  2  "),
            (155.24,155.68, "  1  "),

            (202.09,204.80, "BRUCE D LEE"),
            (204.80,207.64, "DR. MARTIN SBAITSO"),
            (207.64,210.54, "GARY J HUNG"),
            (210.54,213.42, "JAN BOOT"),
            (213.42,216.20, "JOE CUTTER"),
            (216.20,218.91, "MAX POWER"),

            ( 1000, 1000, ''),
            ]
        for stime,etime,word in self.timings:
            surf = f.render( word, True, (255,0,0,0), (0,255,0,0 ) )
            print surf.get_size()
            tex = Texture( (2048,256) )
            tex.updateFromSurface( surf )
            self.tex[word] = tex
            
        self.pose = 0
        self.scaling = 1.0
        self.lastbeattime = 0.0
        self.color = [1.0, 1.0, 0.5]
        self._shader = GLSLShader( vertexshader="data/text.vert", fragmentshader = "data/text.frag")

    def nextPose(self, time):
        self.pose = (self.pose+1) % len(self.tex)
        self.scaling = 1.0
        self.lastbeattime = time
        self.color = [random.random()*0.5, random.random()*0.5, random.random()*0.5 ]

    def draw(self, time, delta, start, stop):
        # find out which text should be displayed
        word=''
        for stime,etime,kword in self.timings:
            if stime < time < etime:
                word = kword
                break
        
        fac = 1.0 - abs( 0.5 * pow( 0.015, time - self.lastbeattime ) - 0.25 )
        self.scaling = fac
        
        glDisable(GL_DEPTH_TEST)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        
        glMatrixMode(GL_MODELVIEW)
        # glScalef(1,12,1)

        glEnable(GL_BLEND)
        glBlendFunc(GL_ONE,GL_ONE)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA )
        
        self.tex[word].bind()
        glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE )
        glColor(*self.color)
        glPushMatrix()
        glScalef( self.scaling, self.scaling, 0.0 )
        self._shader.use()
        self.tex[word].draw( frame=(-1,0,1,1) )
        self._shader.unUse()
        glPopMatrix()
        glDisable(GL_BLEND)
        

    

