from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from math import cos
import random

class Spectrum(Effect):
    """
    A simple effect that draws the spectrum. Note that this is not made for esthetical reasons. Useful if you want to
    know what is going on.
    """

    def __init__(self):
        Effect.__init__(self)
        self.visible = False


    def draw(self, time, delta, start, stop):

        if not self.visible:
            return

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,.5,150)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)


        w = 1.0 / 512.0

        glBegin(GL_QUADS)

        
        for i in xrange(512):

            h = self.fft.getSmoothSpectralDensity(i,i+1)
            segment = i / 16
            glColor3f((segment&1)*.5+.5, (segment&2)*.5+.5, (segment&4)*.5+.5)
            
            
            glVertex2f(i*w, 0)
            glVertex2f((i+1)*w, 0)
            glVertex2f((i+1)*w, h)
            glVertex2f(i*w, h)
            
            
        glEnd()

       

    
