from math import *
from effect import *
import simpleloader
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import perlin

#try:
#    from cgtypes import *
#except:
#    from cgkit.cgtypes import *

from core import GLSLShader, Texture, TextureLoader


class Scene(Effect):
    def __init__(self, screenDim, modelname):
        Effect.__init__(self)
        (self._list, bbox) = simpleloader.simpleLoader(modelname)
        self.fov = 85
        self.xnoise = perlin.PerlinNoise((32,),perlin.ease_interpolation)
        self.ynoise = perlin.PerlinNoise((34,),perlin.ease_interpolation)
        self.test = 0
        # self.psys = ParticleSystem(screenDim)
        self.objShader = GLSLShader(vertexshader = [
            """
            uniform float time;
            varying vec2 tc;
            varying vec3 vcol;
            void main(void)
            {
                vec4 v = vec4(gl_Vertex);		
                float a = length(v);
                v.y += cos(a+time) * .1 * a;
            
                gl_Position = gl_ModelViewProjectionMatrix * v;
                vec3 p = (gl_ModelViewProjectionMatrix * v).xyz;
                vcol = gl_Color.rgb;
                vec3 n = normalize(gl_NormalMatrix * gl_Normal);
                tc = vec2(n.x*.5+.5,n.y*.5+.5);
            
            }

            """],
                                    fragmentshader = [
            """
            uniform sampler2D T0;
            varying vec2 tc;
            varying vec3 vcol;
            void main(void)
            {
            vec3 base = texture2D(T0, tc).rgb * .4;
            gl_FragColor.rgb = base + vcol;

            }
            
            """]
        )
                                                
           
                            
        self.objShader.compile()
        self.envmap = TextureLoader("data/cafe.png")

        
    def draw(self, time, delta, start, end):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)

        xn = 0
        yn = 0
        ntime = time * .3
        for i in xrange(3):
            xn += self.xnoise.value_at((ntime*(i*1+1),) ) * 1.0 / (i+1) 
            yn += self.ynoise.value_at((ntime*(i*1+1),) ) * 1.0 / (i+1)

        xn *= 0.1
        yn *= 0.1

        if self.fft:
            self.test =  self.test * .95 + (self.fft.getSpectralDensity(0,10) / 10.0) * .05

        #self.psys.distort = self.test


#        glTranslatef(xn, yn, -5+cos(time))

#        glLightfv(GL_LIGHT0,GL_POSITION,[0,0,1,0])
#        glLightfv(GL_LIGHT0,GL_DIFFUSE,[.5,.5,.5,1])
#        glLightfv(GL_LIGHT0,GL_SPECULAR,[1,1,1,1])
#        glEnable(GL_LIGHT0)
#        glDisable(GL_LIGHTING)


        glDisable(GL_BLEND)

        # self.psys.update(time, delta)


        t = time * .1


        glEnable(GL_TEXTURE_2D)
        self.envmap.bind()
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T, GL_REPEAT)


        self.objShader.use()
        self.objShader.uniforms.T0 = 0


        for y in [-1,0,1]:
            for x in [-1,0,1]:

                self.objShader.uniforms.time = time + x + y + self.test
                glMatrixMode(GL_MODELVIEW)
                glLoadIdentity()
                gluLookAt(sin(time*.2)*20,yn+cos(time*.3)*5,5 + cos(time*.2),
                  0,0,0,0,1,0)


                s = .9
                up = self.xnoise.value_at(((t+y*1+1),) )
                up += self.ynoise.value_at(((t+x*1+1),) )
                glTranslatef(x*10,up,y*10)


                rotspeed = cos(x*y)
                rotsign = rotspeed > 0
                if rotsign == 0:
                    rotsign == -1


                glRotatef(x*31.854+time*rotsign*(4+rotspeed),1,0,0)
                glRotatef(y*40.3213+time*rotsign*(2.41234+rotspeed),0,1,0)
                glColor3f(1,1,1)
                glScalef(s,s,s)


                glEnable(GL_DEPTH_TEST)

                glCallList(self._list)




        self.objShader.unUse()
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_LIGHTING)
        glDisable(GL_LIGHT0)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        # self.psys.draw(time, delta)

