from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import math
import random

from effect import Effect

class Rings(Effect):

    def __init__(self):
        Effect.__init__(self)

    def draw(self, time, delta, start, stop):

        glBlendFunc(GL_ONE, GL_ONE)
        glEnable(GL_BLEND)

        time = time * 5
        glDisable(GL_DEPTH_TEST)
        glDisable(GL_TEXTURE_2D)
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        glOrtho(-1,1,-.75,.75 ,0.1,1000);
        glTranslatef(0,0,-70);


        stomding = math.cos(time)*.3 + .3
        
        lastRadius = .01 #stomding*.1+0.11
        currentRadius = .01
        spacing = .01 + self.fft.getSmoothSpectralDensity(0,1) * .05

        glBegin(GL_QUADS)
        for i in xrange(20):

            currentRadius = math.cos(i + time) * math.cos(i + time) * .02 + .01
            
            speed = math.cos(i) 
            t = time * speed



            for j in xrange(3):
                c = math.cos((i+j) * 32 + time * .942)
                c = c * c * .7
                glColor3f(c, c, c)
                
                offset = (3.14159264*2.0) / 3.0
                o = t + offset * j
                self._drawFilledRing(lastRadius + spacing, + spacing + lastRadius + currentRadius, o - stomding, o + .2 + stomding, 5)

            lastRadius = lastRadius + spacing + currentRadius

        glEnd()
        glDisable(GL_BLEND)

    def _drawFilledRing(self, innerRadius, outerRadius, startAngle = 0, endAngle = 3.141592*2, segments = 40):

        segR = (endAngle - startAngle) / segments
        for i in xrange(segments):
            x0 = math.cos(startAngle + segR * i) * innerRadius
            x1 = math.cos(startAngle + segR * i + segR) * innerRadius
            x2 = math.cos(startAngle + segR * i) * outerRadius
            x3 = math.cos(startAngle + segR * i + segR) * outerRadius

            y0 = math.sin(startAngle + segR * i) * innerRadius
            y1 = math.sin(startAngle + segR * i + segR) * innerRadius
            y2 = math.sin(startAngle + segR * i) * outerRadius
            y3 = math.sin(startAngle + segR * i + segR) * outerRadius    

            glVertex3f(x0, y0, 0)
            glVertex3f(x1, y1, 0)
            glVertex3f(x3, y3, 0)
            glVertex3f(x2, y2, 0)
    

