from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import random
class Noise(Effect):
    
    def __init__(self, intensity = .05):
        Effect.__init__(self)
        self._buffer = glGenTextures(1)
        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)

        textureSize = 128

        tex=""
        for i in xrange(textureSize*textureSize):
            tex+=chr(random.randint(0,255))*3
            tex+=chr(255)
        
        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, textureSize, textureSize, 0, GL_RGBA, GL_UNSIGNED_BYTE, tex)

        # parameters
        self.intensity = intensity



    def draw(self, time, delta, start, stop):

        # settping transforms
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,1,0,0.1,1000)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        # disable z-buffering
        glDisable(GL_DEPTH_TEST)

        # setup blending
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        # setup texuremapping
        glEnable(GL_TEXTURE_2D)
        glBindTexture(GL_TEXTURE_2D, self._buffer)

        # determine random offsets
        uo = random.random()
        vo = random.random()

        # begin drawing
        glBegin(GL_QUADS)

        # draw first layer of noise
        glColor4f(1, 1, 1, self.intensity)

        glTexCoord2d(uo,vo)
        glVertex2f(0,0)

        glTexCoord2d(1+uo,vo)
        glVertex2f(1,0)

        glTexCoord2d(1+uo,1+vo)
        glVertex2f(1,1)
        
        glTexCoord2d(uo,1+vo)
        glVertex2f(0,1)


        # draw second layer of noise
        scale = 4

        glTexCoord2d(uo*scale,vo*scale)
        glVertex2f(0,0)

        glTexCoord2d((1+uo)*scale,vo*scale)
        glVertex2f(1,0)

        glTexCoord2d((1+uo)*scale,(1+vo)*scale)
        glVertex2f(1,1)
        
        glTexCoord2d(uo*scale,(1+vo)*scale)
        glVertex2f(0,1)

        # end drawing
        glEnd()

        # restore stuff
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)

        

    

    
