from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import math
import random
from core import FBO, GLSLShader
from glew import GL_CLAMP_TO_EDGE


from core import TextureLoader 

from effect import Effect

class motionBlur(Effect):

    def __init__(self, screendim):
        Effect.__init__(self)
        self.color = [1.0, 1.0, 0.5]
        self._screenDim = screendim
        self._bufferDim = screendim
        self._fbo1 = FBO(*self._bufferDim)

    def drawQuad(self):
        umin, umax = 0, (self._screenDim[0]) / float(self._bufferDim[0] )
        vmin, vmax = 0, (self._screenDim[1]) / float(self._bufferDim[1] )

        glBegin(GL_QUADS)
        # glColor4f(1,1,1,1)

        glTexCoord2f(umin, vmin)
        glVertex2f(-1,-1)

        glTexCoord2f(umax, vmin)
        glVertex2f(1,-1)

        glTexCoord2f(umax, vmax)
        glVertex2f(1,1)

        glTexCoord2f(umin, vmax)
        glVertex2f(-1,1)

        glEnd()


    def draw(self, time, delta, start, stop):
        
        self._fbo1.bindAsTexture()
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE)
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        # first use the frame to render, then copy the new frame into the buffer
        glEnable(GL_BLEND)
        glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA )
        glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE )
        glColor4f(1.0,1.0,1.0, 0.9 )
        glDisable(GL_DEPTH_TEST)
        self.drawQuad()
        
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])
        

    

