#experimental mozaic

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from effect import *
from core import FBO, GLSLShader, Texture, TextureLoader
from math import cos

class Mosaic(Effect):

    def __init__(self, screenDim):
        self._bufferDim = (128,128)
        self._screenDim = screenDim
        self._backCopy = FBO(*self._screenDim)
        self._lowresCopy = FBO(*self._bufferDim)
        self._map = TextureLoader("data/mosaicmap.png")


        self._mosaicShader = GLSLShader(
            vertexshader = [
            """
            varying vec2 tc;
            void main(void)
            {
            vec4 v = vec4(gl_Vertex);		
            gl_Position = gl_ModelViewProjectionMatrix * v;
            gl_FrontColor = gl_Color;
            tc = gl_MultiTexCoord0.xy;
            }
            """
            ],
            fragmentshader = [
            """
            uniform sampler2D T0, T1;
            uniform float threshold;
            uniform float frequency;
            varying vec2 tc;
            void main(void)
            {
               vec3 color = texture2D(T0, tc*.5).rgb;;
               float intensity = (color.r + color.g + color.b) / 3.0;
               intensity = intensity * 8.0;
               intensity = round(intensity);
               intensity /= 8.0;


               vec2 modtc = vec2(mod(tc.x,1.0/16.0)*8.0 + intensity  ,mod(tc.y,1.0/32.0)*64.0);
               
               vec3 mapcolor = texture2D(T1, modtc).rgb;;
               
               
               gl_FragColor.rgb = mapcolor;
            }
            """
            ])





    def drawQuad(self):
        umin, umax = 0, 1
        vmin, vmax = 0, 1

        glBegin(GL_QUADS)
        glColor4f(1,1,1,1)

        glTexCoord2f(umin, vmin)
        glVertex2f(0,0)

        glTexCoord2f(umax, vmin)
        glVertex2f(1,0)

        glTexCoord2f(umax, vmax)
        glVertex2f(1,1)

        glTexCoord2f(umin, vmax)
        glVertex2f(0,1)

        glEnd()

    def draw(self, time, delta, start, stop):
    
        # settping transforms
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,0.1,1000)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        # disable z-buffering
        glDisable(GL_DEPTH_TEST)


        self._backCopy.bindAsTexture()
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)
        
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])


        self._lowresCopy.bindAsRenderTarget()
        glViewport(0, 0, self._bufferDim[0], self._bufferDim[1])
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,2,0,2,0.1,1000)

        
        glClearColor(0,0,0,0)
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
        
        glEnable(GL_TEXTURE_2D)


        self.drawQuad()




        self._lowresCopy.unbindAsRenderTarget()
        self._lowresCopy.bindAsTexture()
        self._map.bind(textureUnit = 1)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,0.1,1000)

        glBlendFunc(GL_ONE, GL_ONE)
        glEnable(GL_BLEND)

        glViewport(0, 0, self._screenDim[0], self._screenDim[1])
        self._mosaicShader.use()
        self._mosaicShader.uniforms.T0 = 0
        self._mosaicShader.uniforms.T1 = 1
        
        self.drawQuad()

        self._mosaicShader.unUse()


        glDisable(GL_BLEND)
        glBindTexture(GL_TEXTURE_2D, 0)
        glDisable(GL_TEXTURE_2D)        
        



    
