
from math import *
from effect import *
import simpleloader
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import perlin
import random

#try:
#    from cgtypes import *
#except:
#    from cgkit.cgtypes import *

from core import GLSLShader, Texture, Camera, TextureLoader

class SpikeBall(Effect):
    def __init__(self, speed = 1.0):
        self.speed = speed
        Effect.__init__(self)
        glDisable(GL_LIGHTING)
        (self._spikeball, bbox) = simpleloader.simpleLoader("data/spike.blend.raw")
        self.fov  = 90
        self._shader = GLSLShader( vertexshader = "data/spikeball.vert", fragmentshader = "data/spikeball.frag")
        
        self._texture = TextureLoader("data/cafe.png")

    def draw(self, time, delta, start, end):
        self._shader.use()

        time *= self.speed

        glEnable(GL_DEPTH_TEST)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)        
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        self._texture.bind(0)

        glEnable(GL_TEXTURE_2D)
        #glTranslatef(0, 0, -8)

        zoff = pow(cos(time*pi*2.0*(166.29/120.0)),2) 

        zoff2= pow(cos(time*pi*2.0*(166.29/240.0)),2) * 8.0
        zoff3= pow(sin(time*pi*2.0*(166.29/240.0)),2) * 8.0
        
        gluLookAt(0,4,2 + zoff, 0,0,0, 0,1,0)


        self._shader.uniforms.amp = 1.0-pow(zoff,10.0)
        zoff *= 2.0

        glPushMatrix()
        glRotatef(zoff2*10+time*174.2, 0,1,0)
        glRotatef(zoff3*10+time*163.3, 0,0,1)
        glCallList(self._spikeball)
        glDisable(GL_TEXTURE_2D)
        self._shader.unUse()
        glPopMatrix()
        


class SwirlBall(Effect):
    def __init__(self):
        Effect.__init__(self)
        glDisable(GL_LIGHTING)
        (self._spikeball, bbox) = simpleloader.simpleLoader("data/swirlball.blend.raw")
        self.fov  = 90
        self._shader = GLSLShader( vertexshader = "data/swirlball.vert", fragmentshader = "data/swirlball.frag")
        
        self._texture = TextureLoader("data/cafe.png")

    def draw(self, time, delta, start, end):
        self._shader.use()

        glEnable(GL_DEPTH_TEST)
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)        
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        self._texture.bind(0)

        glEnable(GL_TEXTURE_2D)
        #glTranslatef(0, 0, -8)

        zoff = pow(cos(time*pi*2.0*(166.29/120.0)),2) 

        zoff2= pow(cos(time*pi*2.0*(166.29/240.0)),2) * 8.0
        zoff3= pow(sin(time*pi*2.0*(166.29/240.0)),2) * 8.0
        
        gluLookAt(0,4,20, 0,0,0, 0,1,0)


        self._shader.uniforms.amp = 1.0-pow(zoff,10.0)
        self._shader.uniforms.time = time*10
        zoff *= 2.0

        glPushMatrix()
#        glRotatef(zoff2*10+time*174.2, 0,1,0)
#        glRotatef(zoff3*10+time*163.3, 0,0,1)
        glCallList(self._spikeball)
        glDisable(GL_TEXTURE_2D)
        self._shader.unUse()
        glPopMatrix()
        



class Skull(Effect):
    def __init__(self):
        Effect.__init__(self)
        glDisable(GL_LIGHTING)
        (self._head, bbox) = simpleloader.simpleLoader("data/skull-1.raw")
        (self._jaw, bbox) = simpleloader.simpleLoader("data/skull-2.raw")
        self.fov  = 80
        self._shader = GLSLShader( vertexshader = "data/skull.vert", fragmentshader = "data/skull.frag")
        

    def draw(self, time, delta, start, end):
        self._shader.use()

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)        

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        #glTranslatef(0, 0, -8)
        gluLookAt(0,4,8, 0,0,0, 0,1,0)

        glRotatef(-90, 1, 0, 0)
        glPushMatrix()


        glEnable(GL_DEPTH_TEST)
        glColor(.4,.4,.4,1)

        amp = 0
        amp2 = 0
        x = 56.31 - 50.48
        y = 62.01 - 50.48
        times = [8.7, 9.04, 9.421, 9.63, 10.08, 10.31, 10.34, 10.49, 10.65, 20.42, 20.52, 20.61, 20.95,21.10, 21.65, 21.68, 21.96, 22.20,22.40,
                 33.16, 33.31, 33.39, 33.60, 33.86, 33.96,34.1,
                 #blood - in -  your - face
                 44.76, 45.01, 45.21, 45.45,
                 #we come to crash the par-ty
                 50.48, 50.54, 50.75, 50.83, 51.12, 51.22, 51.44,
                 x+50.48, x+50.54, x+50.75, x+50.83, x+51.12, x+51.22, x+51.44,
                 y+50.48, y+50.54, y+50.75, y+50.83, y+51.12, y+51.22, y+51.44,
                 #blood - in - your - faaaaaaaaaaaaace
                 67.85, 68.11, 68.34, 68.54,
                 
                 100]
        for i in xrange(len(times)-1):
            if times[i] <= time < times[i+1]:

                amp = 1 - (time - times[i]) * 8
                amp2 = 1 - (time - times[i]) 
                if amp < 0:
                    amp = 0

                if amp2 < 0:
                    amp2 = 0
                amp = amp * (1.0 - amp)
#                amp2 = amp2 * (1.0 - amp2)
                    
                break
            
        self._shader.uniforms.amp = amp2*.4 
            
        amp = amp * 30
            
        amp += cos(time) * 3


        glRotatef(amp, 1, 0, 0)
        glCallList(self._head)

        glPopMatrix()
        glRotatef(-amp, 1, 0, 0)
        glCallList(self._jaw)
        self._shader.unUse()

        

class Robots(Effect):
    def __init__(self):
        Effect.__init__(self)
        glDisable(GL_LIGHTING)
        (self._leg1, bbox) = simpleloader.simpleLoader("data/leg1.raw")
        (self._leg2, bbox) = simpleloader.simpleLoader("data/leg2.raw")
        (self._arm1, bbox) = simpleloader.simpleLoader("data/arm1.raw")
        (self._arm2, bbox) = simpleloader.simpleLoader("data/arm2.raw")
        (self._body, bbox) = simpleloader.simpleLoader("data/body.raw")
        (self._head, bbox) = simpleloader.simpleLoader("data/head.raw")
        (self._mouth, bbox) = simpleloader.simpleLoader("data/mouth.raw")

        
        self.fov  = 80
        self._shader = GLSLShader( vertexshader = "data/robot.vert", fragmentshader = "data/robot.frag")
        

    def draw(self, time, delta, start, end):
        self._shader.use()

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)        

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        #glTranslatef(0, 0, -8)
        gluLookAt(3.0*cos(time*0.5),12+cos(time)*4,-16 , 0,0,0, 0,1,0)

        glRotatef(-90, 1, 0, 0)


        glEnable(GL_DEPTH_TEST)
        glColor(.4,.4,.4,1)

        angle = -pow(cos(time*pi*2.0*(166.29/120.0)),10)

        self._shader.uniforms.amp = 1
        self._shader.uniforms.brightness = -angle*1.0


        for i in xrange(-10,11):
            for j in xrange(-5,5):

                glPushMatrix()

                glTranslate(i*5,j*5+((1+i)%2)*2.5,0)

                # left
                glPushMatrix()
                glTranslate(0, 0, 5.658)

                
                glRotate(angle *30 , 1, 0, 0)
                glTranslate(0,0,-5.658)
                glCallList(self._arm1)
                glCallList(self._arm2)
                glPopMatrix()




                glCallList(self._leg1)
                glCallList(self._leg2)
                glCallList(self._leg2)


                glCallList(self._body)



                glTranslate(0,angle,0)

                glCallList(self._head)
                self._shader.unUse()
                glColor3f(1,0,0)
                glTranslatef(0,0.05, 0)
                glCallList(self._mouth)
                self._shader.use()
                glPopMatrix()
        

        self._shader.unUse()


        






class Lasers(Effect):
    def __init__(self):
        Effect.__init__(self)
        (self._list, bbox) = simpleloader.simpleLoader("data/lasers.blend.raw")
        self.fov  = 120

        self._shader = GLSLShader( vertexshader = "data/lasers.vert", fragmentshader = "data/lasers.frag")


    def draw(self, time, delta, start, end):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, .1, 150)        

        glDisable(GL_DEPTH_TEST)
        glBlendFunc(GL_ONE, GL_ONE)
        glEnable(GL_BLEND)

        self._shader.use()
        self._shader.uniforms.offset = self.fft.getSpectralDensity(0,5)

        
        for i in xrange(8):
            r = random.random() * .9


            c = .5+.5*cos(time*sin(i*.432)+i*.254) + r
            glColor(c,c,c,1)
            
            glMatrixMode(GL_MODELVIEW)
            glLoadIdentity()
            gluLookAt(sin(time*.2)*10,cos(time*.2)*10,5 + cos(time*.2),
                      cos(time)*10,0,0,0,1,0)

            glRotatef(time*10*22.492 + i * 222.492 ,1,0,0)

            glCallList(self._list)

        glDisable(GL_BLEND)
        self._shader.unUse()
        

        
