# a really simple threshold post effect

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from effect import *
from core import FBO, GLSLShader
from math import cos

class Invert(Effect):

    def __init__(self, screenDim):
        Effect.__init__(self)

        self._bufferDim = screenDim
        self._fbo = FBO(*self._bufferDim)
        self._screenDim = screenDim
#        self.registerParameter("invert")


        self._invertShader = GLSLShader(
            vertexshader = [
            """
            varying vec2 tc;
            void main(void)
            {
            gl_Position = ftransform();
            gl_FrontColor = gl_Color;
            tc = gl_MultiTexCoord0.xy;
            }
            """
            ],
            fragmentshader = [
            """
            uniform sampler2D T0;
            uniform float invert;
            varying vec2 tc;
            void main(void)
            {

            vec3 color = texture2D(T0, tc).rgb;;
            gl_FragColor = vec4( vec3(1.0,1.0,1.0)- color, 1.0 );
            }
            """
            ])
            
    def drawQuad(self):
        umin, umax = 0, (self._screenDim[0]) / float(self._bufferDim[0] )
        vmin, vmax = 0, (self._screenDim[1]) / float(self._bufferDim[1] )

        glBegin(GL_QUADS)
        glColor4f(1,1,1,1)

        glTexCoord2f(umin, vmin)
        glVertex2f(0,0)

        glTexCoord2f(umax, vmin)
        glVertex2f(1,0)

        glTexCoord2f(umax, vmax)
        glVertex2f(1,1)

        glTexCoord2f(umin, vmax)
        glVertex2f(0,1)

        glEnd()


    def draw(self, time, delta, start, stop):

        # settping transforms
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,0.1,1000)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        # disable z-buffering
        glDisable(GL_DEPTH_TEST)


        self._fbo.bindAsTexture()
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)
        
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])

        glEnable(GL_TEXTURE_2D)
        glBlendFunc(GL_ONE,GL_ONE)
#        glEnable(GL_BLEND)
        self._invertShader.use()
        self._invertShader.uniforms.invert = .1;
        self._invertShader.uniforms.frequency = 600;

        self.drawQuad()

        glDisable(GL_BLEND)

        self._invertShader.unUse()
        glDisable(GL_TEXTURE_2D)




