from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import math
import random

from core import TextureLoader 

from effect import Effect


class Hirmu(Effect):

    def __init__(self):
        Effect.__init__(self)
        self.tex = TextureLoader( 'data/hirmuc.png' )
        self.textrained = TextureLoader( 'data/hirmub.png' )
        self.pose = 0
        self.scaling = 1.0
        self.lastbeattime = 0.0
        self.color = [1.0, 1.0, 0.5]
        self.fade = 1.0
        self.rotdir = 1.0
        self.angle = 0.0
        self.offset = 0.1
        self.cheater = False

    def setPose(self, time, pose):
        self.pose = pose
        self.scaling = 1.3
        self.lastbeattime = time
        self.color = [random.random(), random.random(), random.random() ]

    def setCheatMode(self, enabled):
        self.cheater = enabled

    def draw(self, time, delta, start, stop):
        fac = 1.0 - abs( 0.5 * pow( 0.015, time - self.lastbeattime ) - 0.25 )
        self.scaling = fac

        if 75.21 < time < 86.65:
            self.fade =  (time-75.21) / (86.65-75.21) 
        else:
            self.fade = 1.0

        if self.fade>1.0:
            self.fade = 1.0
        elif self.fade<0.0:
            self.fade = 0.0
        
        glDisable(GL_DEPTH_TEST)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        
        glMatrixMode(GL_MODELVIEW)
        # glScalef(1,12,1)

        hirmuheight = self.tex.getHeight()/12
        yoff = self.pose * hirmuheight
        glEnable(GL_BLEND)
        glBlendFunc(GL_ONE,GL_ONE)


        if self.cheater:
            tex = self.textrained
        else:
            tex = self.tex

        tex.bind()
            
        glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE )
        # glColor(.5,0,.5,1)
        # glTranslatef(0.0,-0.7,0.0)
        self.angle += self.rotdir * delta * 13.0 * self.offset
        glRotatef( self.angle , 0,0,1)
        glColor(self.color[0] * self.fade, self.color[1] *self.fade, self.color[2]*self.fade)
        for j in range(-8,8):
            for i in range(-10,10):
                glPushMatrix()
                glScalef( self.scaling, self.scaling, 0.0 )
                glScalef( 0.3 , 0.3, 1.0 )
                glTranslatef( i * 1.7 , j*1.9, 0.0 )
                #glScalef( 0.7 + 0.3 *math.sin(i+time), math.cos(i* 0.2), 1.0 )
                tex.draw( texcoordframe=(0,yoff, tex.getWidth(), yoff+hirmuheight) )
                glPopMatrix()
        glDisable(GL_BLEND)
        


class ChangingRotationHirmu( Hirmu ):
    def __init__(self):
        Hirmu.__init__(self)
        
    def setPose(self,time,pose):
        Hirmu.setPose( self, time, pose )
        self.rotdir = -self.rotdir
        self.offset = random.random() * 45.0



