from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from effect import *
from core import FBO, GLSLShader
from glew import GL_CLAMP_TO_EDGE

class Glow(Effect):

    def __init__(self, screenDim):
        Effect.__init__(self)

        self._bufferDim = screenDim
        self._fbo0 = FBO(*self._bufferDim)
        self._fbo1 = FBO(*self._bufferDim)


        self._screenDim = screenDim

        self._scaleShader = GLSLShader(
            vertexshader = [
            """
            varying vec2 tc;
            void main(void)
            {
            vec4 v = vec4(gl_Vertex);		
            gl_Position = gl_ModelViewProjectionMatrix * v;
            gl_FrontColor = gl_Color;
            tc = gl_MultiTexCoord0.xy;
            }
            """
            ],
            fragmentshader = [
            """
            uniform sampler2D T0;
            uniform float intensity;
            varying vec2 tc;
            void main(void)
            {
               gl_FragColor.rgb = pow(texture2D(T0, tc).rgb, vec3(intensity));\
            }
            """])


        self._glowShader = GLSLShader(
            vertexshader = [
            """
            varying vec2 tc;
            void main(void)
            {
            vec4 v = vec4(gl_Vertex);		
            gl_Position = gl_ModelViewProjectionMatrix * v;
            gl_FrontColor = gl_Color;
            tc = gl_MultiTexCoord0.xy;
            }
            """
            ],
            fragmentshader = [
            """
            uniform sampler2D T0;
            uniform float bf;
            varying vec2 tc;
            void main(void)
            {
              vec3 base = texture2D(T0, tc + vec2( 0.0, 0.0)*bf).rgb;
              base += texture2D(T0, tc + vec2( 0.527837,-0.085868)*bf).rgb;
              base += texture2D(T0, tc + vec2(-0.040088, 0.536087)*bf).rgb;
              base += texture2D(T0, tc + vec2(-0.670445,-0.179949)*bf).rgb;
              base += texture2D(T0, tc + vec2(-0.419418,-0.616039)*bf).rgb;
              base += texture2D(T0, tc + vec2( 0.440453,-0.639399)*bf).rgb;
              base += texture2D(T0, tc + vec2(-0.757088, 0.349334)*bf).rgb;
              base += texture2D(T0, tc + vec2( 0.574619, 0.685879)*bf).rgb;
              gl_FragColor.rgb = base.rgb / 6.0;;
            }
            """])





        self._glowShader.compile()
        self._scaleShader.compile()


    def drawQuad(self):
        umin, umax = 0, (self._screenDim[0]) / float(self._bufferDim[0] )
        vmin, vmax = 0, (self._screenDim[1]) / float(self._bufferDim[1] )

        glBegin(GL_QUADS)
        glColor4f(1,1,1,1)

        glTexCoord2f(umin, vmin)
        glVertex2f(0,0)

        glTexCoord2f(umax, vmin)
        glVertex2f(1,0)

        glTexCoord2f(umax, vmax)
        glVertex2f(1,1)

        glTexCoord2f(umin, vmax)
        glVertex2f(0,1)

        glEnd()
        
    def draw(self, time, delta, start, end):

        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        # copy backbuffer to FBO
        self._fbo1.bindAsTexture()
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE)
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE)
        
        
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])


        glEnable(GL_TEXTURE_2D)
        glDisable(GL_DEPTH_TEST)


        self._scaleShader.use()
        self._scaleShader.uniforms.intensity = 1.6
        self._fbo0.bindAsRenderTarget()
        self.drawQuad()
        self._fbo0.unbindAsRenderTarget()
        self._scaleShader.unUse()



        spread = .015


        for i in xrange(2):

            self._fbo0.bindAsTexture()
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE)
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE)
            self._fbo1.bindAsRenderTarget()

            self._glowShader.use()
            self._glowShader.uniforms.bf = spread
            self.drawQuad()
            self._glowShader.unUse()
            self._fbo1.unbindAsRenderTarget()

            self._fbo1.bindAsTexture()
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE)
            glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE)
            
            self._fbo0.bindAsRenderTarget()

            self._glowShader.use()
            self._glowShader.uniforms.bf = spread
            self.drawQuad()
            self._glowShader.unUse()
            self._fbo0.unbindAsRenderTarget()



        glEnable(GL_BLEND)
        glBlendFunc(GL_ONE,GL_ONE)


        self._fbo0.bindAsTexture()
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_CLAMP_TO_EDGE)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_CLAMP_TO_EDGE)
            
        
#        glViewport(0, 0, self._screenDim[0], self._screenDim[1])
        self._glowShader.use()
        self._glowShader.uniforms.bf = spread
        self.drawQuad()
        self._glowShader.unUse()
        
        glDisable(GL_BLEND)



        glBindTexture(GL_TEXTURE_2D, 0)

        glDisable(GL_TEXTURE_2D)
        glViewport(0, 0, self._screenDim[0], self._screenDim[1])
