# free directional tunnel in pixel shader experiment
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

from effect import Effect
from core import GLSLShader, Texture, TextureLoader

import math

class FDTunnel(Effect):

    def __init__(self):

        self._texture = TextureLoader("data/cafe.png")
#        self._texture = TextureLoader("data/cloud.png")

#        self._shader = GLSLShader( vertexshader = "data/laser.vert",
#                                  fragmentshader = "data/laser.frag" )
        self._shader = GLSLShader( vertexshader = "data/fdtunnel.vert",
                                  fragmentshader = "data/fdtunnel.frag" )
#        self._shader.compile()
        
    def drawQuad(self):

        glBegin(GL_QUADS)
        glColor4f(1,1,1,1)

        glVertex2f(0,0)

        glVertex2f(1,0)

        glVertex2f(1,1)

        glVertex2f(0,1)

        glEnd()


    def draw(self, faketime, delta, start, stop):

        # settping transforms
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,0,1,0.1,1000)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        # disable z-buffering
        glDisable(GL_DEPTH_TEST)
        glDisable(GL_BLEND)

        self._shader.use()

        self._texture.bind(textureUnit = 0)
        glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
        glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT )
#        glTexParameterf( glew.GL_TEXTURE_2D, glew.GL_TEXTURE_WRAP_R, GL_CLAMP )
        
        self._shader.use()
        import time
        realtime = time.time()-henk
        self._shader.uniforms.offset = (realtime) * 4.0
        self._shader.uniforms.garblefactor = 1.0 # use this to sync distortion to beats and such
        self._shader.uniforms.fuglyness = 1.0*math.sin(realtime*10.0)
        #print delta

        self.drawQuad()
        
        
        self._shader.unUse()

        self._shader.unUse()
        glBindTexture(GL_TEXTURE_2D, 0)
        
import time
henk = time.time()
                                  

        
