from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import math
import random

from core import TextureLoader 

from effect import Effect

class dansMongolen(Effect):

    def __init__(self):
        Effect.__init__(self)
        self.tex = []
        
        for frame in range(48):
            self.tex += [TextureLoader( 'data/jump_%d.jpg' % (frame+1) )]
            
        self.pose = 0
        self.scaling = 1.0
        self.lastbeattime = 0.0
        self.color = [1.0, 1.0, 0.5]

    def nextPose(self, time):
        self.pose = (self.pose+1) % len(self.tex)
        self.scaling = 1.3
        self.lastbeattime = time
        self.color = [random.random()*0.5, random.random()*0.5, random.random()*0.5 ]

    def draw(self, time, delta, start, stop):
        fac = 1.5 - abs( 0.5 * pow( 0.015, time - self.lastbeattime ) - 0.25 )
        self.scaling = fac
        
        glDisable(GL_DEPTH_TEST)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        
        glMatrixMode(GL_PROJECTION);
        glLoadIdentity();
        
        glMatrixMode(GL_MODELVIEW)
        # glScalef(1,12,1)

        glEnable(GL_BLEND)
        glBlendFunc(GL_ONE,GL_ONE)
        
        self.tex[self.pose].bind()
        glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE )
        # glColor(.5,0,.5,1)
        # glTranslatef(0.0,-0.7,0.0)
        # glDisable(GL_BLEND)
        # glRotatef( time, 0,0,1)
        glColor(*self.color)
        glPushMatrix()
        glScalef( self.scaling, self.scaling, 0.0 )
        # glScalef( 0.3 , 0.3, 1.0 )

        #glScalef( 0.7 + 0.3 *math.sin(i+time), math.cos(i* 0.2), 1.0 )
        self.tex[self.pose].draw()
        glPopMatrix()
        glDisable(GL_BLEND)
        

    

