from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from time import clock as clock
import math
import random

from effect import Effect

class Copper(Effect):

    def __init__(self):
        self.start = clock()
        self.frame=0
        Effect.__init__(self)

    def draw(self, time, delta, start, stop):
        
        glDisable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)
        
        glMatrixMode(GL_MODELVIEW)
        glPushMatrix()
        glLoadIdentity()
        glTranslatef(0.0, 0.0, -1.0)
        
        glMatrixMode(GL_PROJECTION)
        glPushMatrix()
        glLoadIdentity()
        glOrtho(0.0, 640.0, 480.0, 0.0, 0.0, 1000)
        glDisable(GL_LIGHTING)

        # first
        start1 = 240.0 + math.sin(time * 2.0) * 200.0;
        self._cop(time, start1, 1)

        # 2nd
        start2 = 240.0 + math.sin(time * 2.0 + 0.2) * 200.0
        self._cop(time, start2, 2)
        
        # 3rd
        start3 = 240.0 + math.sin(time * 2.0 + 0.4) * 200.0
        self._cop(time, start3, 3)

        glPopMatrix()

        glMatrixMode(GL_MODELVIEW)
        glPopMatrix()

    def _cop(self, time, start, flag):
        width = 640
        height = 40
        glBegin(GL_QUADS)
        for i in range(0, height):
            y = start + i
            f = math.sin(1.0 * i / height * math.pi)  / 2.0 + 0.5
            f = f * f * f
            if (time > 13.0):
                f = f * (15.0 - time) / 2.0
            if (flag == 1):
                glColor3f(0, f, 0)
            if (flag == 2):
                glColor3f(f, f, f)
            if (flag == 3):
              glColor3f(f, 0, 0)
            glVertex3f(0.0, y, 0.0)
            glVertex3f(width, y, 0.0)
            glVertex3f(width, y + 1.0, 0.0)
            glVertex3f(0.0, y + 1.0, 0.0)
        glEnd();
