# a really simple displacement post effect

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from effect import *
from core import FBO, GLSLShader
from math import cos
import random

class BrokenDecoder(Effect):

    def __init__(self, screenDim):
        Effect.__init__(self)

        self._bufferDim = screenDim
        self._baseMap = FBO(*self._bufferDim)
        self._displaceMap = FBO(*self._bufferDim)
        self._previously = False
        
        self._screenDim = screenDim

        self._thresholdShader = GLSLShader(
            vertexshader = [
            """
            varying vec2 tc;
            void main(void)
            {
            vec4 v = vec4(gl_Vertex);		
            gl_Position = gl_ModelViewProjectionMatrix * v;
            gl_FrontColor = gl_Color;
            tc = gl_MultiTexCoord0.xy;
            }
            """
            ],
            fragmentshader = [
            """
            uniform sampler2D baseMap;
            uniform sampler2D displaceMap;
            uniform float intensity;
            uniform float distance;
            varying vec2 tc;
            void main(void)
            {

               float fIntensity = 0.0;
               if ( cos(intensity*1.0 + floor(tc.y*96.0)) *
               cos(intensity*2.1 + floor(tc.x*128.0)) < .4) {
                 fIntensity = 0.01;
               }
               
               
               vec2 block = vec2(cos(floor(tc.x * 128.0))*fIntensity, sin(floor( tc.y * 96.0))*fIntensity);

               
               
               

               vec3 baseColor = texture2D(baseMap, tc).rgb;
               vec3 color = texture2D(displaceMap, tc).rgb - baseColor;
               vec3 dcolor = texture2D(displaceMap, tc).rgb;
               vec2 offset0 = vec2(color.r*0.1, color.b*0.1);
               vec2 offset1 = vec2(color.g*0.1, color.r*0.1);
               vec2 offset2 = vec2(color.b*0.1, color.g*0.1);
               
//               vec2 offset = vec2(distance*cos((color.r-.5)*4.0*6.282),distance*sin((color.g-.5)*4.0*6.282));

               float red = texture2D(baseMap, tc + block+offset0).r;
               float green = texture2D(baseMap,tc + block+offset1).g;
               float blue = texture2D(baseMap, tc + block+offset2).b;




               gl_FragColor.rgb = (baseColor + vec3(red,green,blue)) * .5 - dcolor *.1 - color*.3;
            }
            """
            ])
            
    def drawQuad(self):
        umin, umax = 0, (self._screenDim[0]) / float(self._bufferDim[0] )
        vmin, vmax = 0, (self._screenDim[1]) / float(self._bufferDim[1] )

        glBegin(GL_QUADS)
        glColor4f(1,1,1,1)

        glTexCoord2f(umin, vmin)
        glVertex2f(0,0)

        glTexCoord2f(umax, vmin)
        glVertex2f(1,0)

        glTexCoord2f(umax, vmax)
        glVertex2f(1,1)

        glTexCoord2f(umin, vmax)
        glVertex2f(0,1)

        glEnd()


    def draw(self, time, delta, start, stop):

        if self.fft.getSmoothSpectralDensity(0,20) < 1.5:
            self.previously = False
            return
        else:


            # settping transforms
            glMatrixMode(GL_PROJECTION)
            glLoadIdentity();
            glOrtho(0,1,0,1,0.1,1000)

            glMatrixMode(GL_MODELVIEW)
            glLoadIdentity();
            glTranslatef(0,0,-70)

            # disable z-buffering
            glDisable(GL_DEPTH_TEST)


            if  not self.previously:

                self._baseMap.bindAsTexture()
                glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
                glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)

                glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])


            self._displaceMap.bindAsTexture()
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)
            glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])


            self._baseMap.bindAsTexture(textureUnit=0)
            self._displaceMap.bindAsTexture(textureUnit=1)

            glEnable(GL_TEXTURE_2D)
    #        glBlendFunc(GL_ONE,GL_ONE)
    #        glEnable(GL_BLEND)
            self._thresholdShader.use()
            self._thresholdShader.uniforms.intensity = cos(time)*.5 + .5
            self._thresholdShader.uniforms.distance = cos(time*2)*.1 
            self._thresholdShader.uniforms.baseMap = 0
            self._thresholdShader.uniforms.displaceMap = 1

            self.drawQuad()

    #        glDisable(GL_BLEND)

            self._thresholdShader.unUse()
            glDisable(GL_TEXTURE_2D)


            self._baseMap.bindAsTexture()
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
            glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)

            glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])

            self.previously = True
