from effect import Effect
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from math import cos

class Blitter(Effect):

    def __init__(self, screenres, intensity = .1, barHeight = .6, barCount = 10):
        Effect.__init__(self)

        format = GL_RGBA
        self.width = 1024

        if (screenres[1] > 512):
            self.height = 1024
        else:
            self.height = 512
        
        self._buffer = glGenTextures(1)
        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexImage2D(GL_TEXTURE_2D, 0, format, self.width, self.height, 0, format, GL_UNSIGNED_BYTE, "aaaa" * self.width * self.height)
        self._screenres = screenres

        # parameters
        self.intensity = intensity
        self.barHeight = barHeight
        self.barCount =  barCount


    def draw(self, time, delta, start, end):

        glDisable(GL_DEPTH_TEST)
 
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity();
        glOrtho(0,1,1,0,0.1,1000)
 
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity();
        glTranslatef(0,0,-70)

        glEnable(GL_TEXTURE_2D)

        glBindTexture(GL_TEXTURE_2D, self._buffer)
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenres[0], self._screenres[1])

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)



        # start drawing
        glBegin(GL_QUADS)


        for i in xrange(self.barCount):

            y = cos(i*.83215+time*0.02)*.5+.5
            barheight = self.barHeight
            intensity = cos(time*.88+i*1.32) * self.intensity + self.intensity


            vmax =  (self._screenres[1]/float(self.height))
            v = y * vmax


            v= 1.0-v
            if v < ((self.height-self._screenres[1])/self.height):
                v = (self.height-self._screenres[1])/self.height

            if v > 0.9:
                v = 0.9
         


            vo = 0


            umax = self._screenres[0] / float( self.width)
            

            ## first quad

            glColor(1,1,1,0)
            glTexCoord2d(0, v)
            glVertex2f(0, y-barheight)

            glTexCoord2d(umax ,v)
            glVertex2f(1,y-barheight)

            glColor(1,1,1,intensity)
            glTexCoord2d(umax, v)
            glVertex2f(1,y)
            glTexCoord2d(0,v)
            glVertex2f(0,y)


            ## second quad

            glColor(1,1,1,0)
            glTexCoord2d(0,v)
            glVertex2f(0,y+barheight)

            glTexCoord2d(umax ,v)
            glVertex2f(1,y+barheight)

            glColor(1,1,1,intensity)
            glTexCoord2d(umax, v)
            glVertex2f(1,y)

            glTexCoord2d(0,v)
            glVertex2f(0,y)

                
        glEnd()

        glDisable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)
#        glEnable(GL_DEPTH_TEST)
