
RELEASE = False
RELEASE = True # toggle this for fullscreen and timeline/spectrum overlays

import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import readmarkers
import glew

from core import *
from effects import *
from splash import *
import fmod

# try detecting the IPython shell
try:
    __IP
    ipython = True
    print "IPython shell detected."
except NameError:
    ipython = False
    

ipython = False

# try importing psyco if we are not using the IPython shell, this gives a slight performance boost
try:
    if not ipython:
        import psyco
        psyco.full()
except:
    print "[warning]: no psyco; install psyco for a slight performance boost"

g_screensize = (640, 480)


#setup fmod
audiosystem = fmod.System(True)
fft = fmod.FFT()

# setup screen
passed, failed = pygame.init()

if failed:
    print "[error]: pygame init failed"

screen = pygame.display.set_mode(g_screensize, OPENGL | DOUBLEBUF )
if RELEASE:
    pygame.display.toggle_fullscreen()
    pygame.mouse.set_visible(0)


pygame.display.set_caption("eenakter")

glew.glewInit()

if screen is None:
    print "[error]: couldn't create opengl display"



###
#splash = Rainbow()
#splash.show()

###



markers = readmarkers.readmarkers("data/useful/markers.txt")
beatmarkers = readmarkers.readmarkers("data/labels_in_markers_formaat.txt")


#########################################################################

# construct effects
blitter = Blitter(g_screensize, intensity = .1, barHeight = .6, barCount = 10)

interlace = Interlace(intensity = .2)

noise = Noise(intensity = .05)

gradient = FFTGradient(topColor = [.6, .1, 0], bottomColor = [.3, 0, 0])


distort = Distort(g_screensize, intensity = .2, amplitude = 50)

rings = Rings()
lasers = Lasers()


glow = Glow(g_screensize)

threshold = Threshold(g_screensize)
#displace = Displace(g_screensize)
#brokendecoder = BrokenDecoder(g_screensize)

copper = Copper();

tunnel = FDTunnel()


spikeball = SpikeBall(1.0)
slowspikeball = SpikeBall(0.1)
swirlball = SwirlBall()
skull = Skull()

textoverlay = textOverlay()


hirmutest = Image("data/hirmu.png" )
hirmuoffsets = [1, 0, 1, 3, 1, 0, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 0, 1, 10, 1, 3, 1, 8, 1, 8, 1, 2, 1, 10, 1, 5, 1, 8, 1, 4, 1, 10, 1, 11, 1, 8, 1, 2, 1, 10, 1, 5, 1, 8, 1, 9, 1, 10, 1, 6, 1, 0, 2, 3, 4, 5, 6, 9, 4, 2, 10, 7, 5, 3, 11, 0, 1, 8, 1, 0, 1, 10, 1, 5, 3, 0, 4, 6, 8, 5, 11, 9, 10, 8, 6, 5, 7, 4, 3, 0, 1, 10, 11, 7, 9, 8, 3, 5, 0, 4, 1, 8, 1, 6, 4, 2, 1, 3, 10, 0, 7, 9, 5, 11, 0, 8, 5, 2, 0, 3, 5, 7, 8, 6, 3, 2, 0, 10, 8, 6, 4, 3, 2, 9, 8, 6, 4, 3, 2, 11, 1, 4, 10, 11, 8, 9, 8, 5, 2, 5, 3, 7, 0, 5, 3, 6, 1, 5, 2, 7, 4, 5, 7, 8, 2, 4, 9, 10, 1, 3, 1, 0, 3, 10, 6, 11, 0, 6, 2]
beatcounter = 0

spectrum = Spectrum()
timeline = TimeLine()
hirmu = Hirmu()
chirmu = ChangingRotationHirmu() 
# hirmu = dansMongolen()
dansmongolen = dansMongolen()
motionblur = motionBlur( g_screensize )
invert = Invert( g_screensize )

robots = Robots()

#overlaycomputer = OverlayComputer( g_screensize )

# this is where we define the effect order

# important timing points:
# 69.32 - silence
# 75.21 - breakdown
# 86.65 - rhyme verse 1
# 98.10 - rhyme verse 2
# 109.72 - beat verse
# 132.70 - breakdown 2 verse 1
# 144.25 - breakdown 2 verse 2
# 155.88 - smashy verse
# 167.44 - smashy verse [drum follows lead entirely]
# 178.99 - biiiig chorus thing
# 202.09 - coda
# 225.19 - end


schedule = [
    (0, 132.7, [lasers]) ,
    (202.09, 225.19, [lasers]), 
    # [intro]
    (0, 23.2, [skull]),

    # [leadin]
    (33, 34.6, [skull]),
    (44.8, 46.0, [skull]),
    (46.22, 69.31, [skull]),

    # [leadin spikiez]
    (23.2, 33, [spikeball]),
    (34.6, 44.8, [spikeball]),
    (46, 69.31, [spikeball]),
    (69.31, 75.21, [slowspikeball]),
    (98.10, 104.5, [swirlball]),
    (109.72, 132.7, [swirlball]),
    (178.99, 190.32, [swirlball]),
    (190.32, 202.09, [rings]),
    (202.09, 213.43, [spikeball]),
    (213.43, 225.19, [rings]),
    
    (86.65, 109.72, [rings]),  
    (109.72, 132.7, [rings]),    
    (155.88, 178.99, [rings]),    

    (132.70, 178.99, [tunnel]),

    (152.79, 155.88, [spikeball]),
    
    (144.25, 152.79, [robots]),
    (155.88, 178.99, [robots]),
    (178.99, 202.09, [robots]),
    
    # [synth parts]
    (46.22, 47.81, [hirmu]),
    (52.21, 53.63, [hirmu]),
    (57.85, 59.70, [hirmu]),
    (63.76, 65.13, [hirmu]),
    (66.67, 68.44, [hirmu]),
    (75.21, 86.65, [hirmu]),    
    (86.65, 109.72, [hirmu]),
    (109.72, 132.7, [hirmu]),
    (155.88, 178.99, [chirmu]),

    (152.79, 155.88, [chirmu]),  # DANCING IDIOTS
    (178.99, 202.09, [dansmongolen]),  # DANCING IDIOTS

    (0, 178.99, [textoverlay]), # hirmu
    (0, 230, [glow]),

    (69.31, 104.5, [motionblur] ),
    (132.70, 152.79, [motionblur] ),
    (202.09, 230, [motionblur] ),

    (178.99, 360, [textoverlay]), # hirmu

    (28.52,28.89,[threshold]),
    (39.62,39.77,[threshold]),
    (120.38,121.13,[threshold]),
    ]

if not RELEASE:
    schedule += [ (0, 360, [spectrum,timeline] ) ]
    pass

#schedule = [ (0,360, [textoverlay] ),
#             (0,360, [glow ] ),
#             (0,360, [overlaycomputer]),
#             ]

timeline.setSchedule(schedule)
timeline.setMarkers(markers)

#########################################################################

from time import time as gettime


def run():

    glDisable(GL_TEXTURE_2D)
    glDisable(GL_BLEND)

    tune = audiosystem.createStream("data/01-a-crashthaparty-192vinylrip.ogg")

    tune.play()

    lastTime = -1
    lastbeatTime = 0

    starttime = pygame.time.get_ticks() / 1000.0
    clock = pygame.time.Clock()
    running = True
    ### demoloop
    while running:
        clock.tick()
        time =  tune.getTime()

        
#        time = gettime() - starttime
        #time = pygame.time.get_ticks() / 1000.0
        #time -= starttime
        
        if lastTime == -1:
            lastTime = time

        isBeat = readmarkers.ismarkerinperiod( beatmarkers, lastTime, time );
        if isBeat:
            global beatcounter 
            beatcounter += 1
            lastbeatTime = time
            hirmu.setPose( time, hirmuoffsets[beatcounter % len(hirmuoffsets)] )
            chirmu.setPose( time, hirmuoffsets[beatcounter % len(hirmuoffsets)] )
            dansmongolen.nextPose( time )
            textoverlay.nextPose( time )

        fft.updateSpectrum(time - lastTime)
        events = pygame.event.get()
        for event in events:
            if event.type==QUIT:
                running = False
            if event.type==KEYUP:
                if event.key == K_LSHIFT:
                    hirmu.setCheatMode( False )
                
            if event.type==KEYDOWN:
                if event.key == K_LSHIFT:
                    hirmu.setCheatMode( True )
                    
                if event.key == K_s:
                    spectrum.visible = (~spectrum.visible)

               # if event.key == K_UP:
               #     t = readmarkers.getnext(markers,time)
               #     if t != None:
               #         tune.seek(t)

               # if event.key == K_DOWN:
               #     t = readmarkers.getprevious(markers,time)
               #     if t != None:
               #         tune.seek(t)


                if event.key == K_RIGHT:
                    tune.seek(time + 5)
                if event.key == K_LEFT:
                    tune.seek(time - 5)
                if event.key == K_UP:
                    tune.seek(time + 20)
                if event.key == K_DOWN:
                    tune.seek(time - 20)
                if event.key == K_PAGEUP:
                    tune.seek(time + 60)
                if event.key == K_PAGEDOWN:
                    tune.seek(time - 60)
                if event.key == K_ESCAPE or event.key == K_q:
                    running = False




        beatfac  =0.1-(time-lastbeatTime)
        if beatfac>1.0:
            beatfac = 1.0
        elif beatfac<0.0:
            beatfac = 0.0
            
        glClearColor(beatfac*8.0, beatfac*8.0, beatfac*5.0 , 0)
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
        renderSchedule(schedule, time, time-lastTime, fft)
        glFlush()
        glFinish()
        pygame.display.flip()

        lastTime = time

        timeStr = `time`.split(".")
        marker = readmarkers.getclosest(markers,time)
#        pygame.display.set_caption("eenakter "+ timeStr[0] + "." + timeStr[1][:3] + ": [" + marker+"]")

    tune.stop()

run()
