varying vec2 screenPosition;
varying vec4 worldPosition;
varying vec4 lightCol;
uniform float amp;
varying float dist;

void main(void) {


  vec4 v = vec4(gl_Vertex);		
  worldPosition = gl_ModelViewMatrix * v;
  float l = 1.0;
  vec3 n = (gl_NormalMatrix * gl_Normal).xyz;

  vec4 p = (gl_ModelViewProjectionMatrix * v);

  dist = length(worldPosition.xyz) * 0.01;
          
  vec4 aap = gl_Color;                        

  float d = length(v*.012);
  float c = d*(1.0-d*4.3) * 2.4;
  float e = 0.0;
  lightCol = dot(n, vec3(0,0,1)) * vec4(.8,.8,.7,1) * amp;
  gl_Position = p;

}
