from PIL import Image
from PIL import TgaImagePlugin

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

from external import Texture

import alphaconv

class TextureLoader( Texture ):
    def __init__( self, fn ):
        im = Image.open( fn )
        #print dir(im),im.size
        Texture.__init__( self, im.size )
        self._texture_image_2d( im, False )
        
        
    def _texture_image_2d(self, image, mipmap):
        self.bind()

        if image.mode == 'RGB':
            data = image.tostring("raw","RGBX",0,-1)[:]
        elif image.mode == 'RGBA':
            data = image.tostring("raw","RGBA",0,-1)[:]
        else:
            assert False, image.mode

        width, height = image.size
        dcopy = data[:]
        alphaconv.convert(dcopy, width, height)
        data =dcopy
            
        if mipmap:
            gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, width, height,
                              GL_RGBA, GL_UNSIGNED_BYTE, data)
        else:
            glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height,
                         0, GL_RGBA, GL_UNSIGNED_BYTE, data)


        self.size = image.size[:]
        
        
