from sceneentity import *
from scenelight import *


class RenderJob:
    pass    
    


class SceneRenderer:

    def __init__(self, scene):
        self._lightIndex = 0
        self._entities = []
        self._scene = scene
        self._camera = None


    def render(self, camera, scene, time, delta):


        self._camera = camera
        self._entities = []


        self._lightIndex = 0
        nodeStack = []
        nodeStack.append(scene.getRootNode())

        while len(nodeStack) != 0:
            currentNode = nodeStack[-1]
            nodeStack.pop()

            if currentNode is None:
                continue

            currentNode.update(False, False)
            for obj in currentNode._objects:
                self.processObject(obj)
            
            for child in currentNode._children:
                nodeStack.append(child)

        renderEntities()
       

            
    def processObject(self, obj):

        if obj.__class__ == SceneEntity:
            self.processEntity(obj)

        elif obj.__class__ == SceneLight:
            self.processLight(obj)
        

    def processLight(self, light):
        self._lightIndex += 1


    def processEntity(self, entity):
        self._entities.append(entity)


    # ________________

    def renderEntities(self):

        for entity in self._entities:

            parent = entity.getParent()
            objectTransform = parent.getWorldTransform()

            self._camera.pushGL()

            glMultMatrixd(objectTransform.toList())

            entityMaterial = entity.getMaterial()
            entityMesh = entity.getMesh()

            for submesh in entityMesh.subMeshes:
                submeshMaterial = subMesh.getMaterial()

                material = submeshMaterial
                if not submeshMaterial:
                    material = entityMaterial

                material.pushGL()

                
                # handle uniforms here
                shader = material.getShader()
                if shader:
                    pass
                
                
                submesh.pushGeometry()

                material.popGL()
        
            

