from cgtypes import vec3, quat, mat4


class SceneNode:

    def __init__(self, scene, parent = None):
        self._scene = scene
        self._children = set()
        self._objects = set()
        self._pivot = vec3(0,0,0)
        self._parent = parent
        self._orientation = quat(1, 0, 0, 0)
        self._position = vec3(0,0,0)
        self._scale = vec3(1,1,1)

        self._worldTransform = mat4()
        self._worldTransform.identity()

        self._worldOrientation = quat(1,0,0,0)
        


    # __________________________________


    def getWorldTransform(self):
        pass

    def getWorldOrientation(self):
        pass

    # _________________________________

    def getParent(self):
        return self._parent

    def getScene(self):
        return self._scene


    def addObject(self, sceneobject):
        self._objects.append(sceneobject)


    def createChildNode(self):
        return SceneNode(scene = self._scene, parent = self)
        

    # _________________
    
    def onUpdate(self, time, delta):


        parentTransform = mat4()
        parentTransform.identity()

        parentOrientation = quat(1, 0, 0, 0)

        if self._parent:
            parentTransform = parent.getWorldTransform()
            parentOrientation = parent.getWorldOrientation()


        rotationMatrix = self._orientation.toMat4()
        translationMatrix = mat4()
        translationMatrix.translation(self._position)
        scalingMatrix = mat4()
        scalingMatrix.scaling(self._scale)

        self._worldTransform.identity()
        self._worldTransform = parentTransform * translationMatrix * rotationMatrix * scalingMatrix
        self._worldOrientation = parentOrientation * self._orientation

        
        pass

    def update(self, updateChildren, parentChanged):
        if updateChildren:
            for child in self._children:
                child.update(updateChildren, parentChanged)
