class Parameter(object):

    def __init__(self):

        self._defaultValue = None
        self._value = self._defaultValue
        self._partners = []
        self._eventHandlers = []
        self._midiId = None
        self._midiChannel = None
        

    def setValue(self, value):
        self._value = value

    def getValue(self):
        return self._value

    def setDefaultValue(self, defaultValue):
        self._defaultValue = defaultValue

    def getDefaultValue(self):
        return self._defaultValue

    def hook(self, partner):
        self._partners.append(partner)
        partner.addLink(self)

    def unhook(self, partner):
        self._partners.remove(partner)
        partner.removeLink(self)


    def _setCallerValue(self, caller, value):
        if self._value == value:
            return

        self._value = value
        for partner in self._partners:
            if partner != caller:
                partner.setCallerValue(self, self._value)
        
        for handler in self._eventHandlers:
            handler.valueChanged(self)
        

    def _addLink(self, partner):
        self._partners.append(partner)

    def _removeLink(self, partner):
        self._partners.remove(partner)

    def setMidiId(self, id):
        self._midiId = id

    def getMidiId(self):
        return self._midiId
    
    def setMidiChannel(self, channel):
        self._midiChannel = channel

    def getMidiChannel(self):
        return self._midiChannel


class ParameterEventHandler(object):
    
    def __init__(self):
        pass

    def valueChanged(self, caller):
        pass
