class Material:

    def __init__(self,
                 shader = None,
                 diffuse = (0.8, 0.8, 0.8, 1.0)
                 ambient = (0.2, 0.2, 0.2, 1.0)
                 specular = (0,0. 0.0, 0.0, 1.0)
                 emission = (0.0 ,0.0, 0.0, 1.0)
                 shininess = 1.0
                 doubleSided = False
                 ):
        self._shader = shader
        self._diffus = diffuse
        self._ambient = ambient
        self._specular = specular
        self._emission = emission
        self._shininess = shininess
        self._doubleSided = doubleSided
        self._textures = {}

    # _________________

    def setTexture(self, slot, texture):
        self._textures[slot] = texture

    def getTexture(self, slot):
        return self._textures[slot]
    
    # ________________
       

    def setShader(self, shader):
        self._shader = shader

    def getShader(self):
        return self._shader

    # _____________

    def setDiffuse(self, diffuse):
        self._diffuse = diffuse

    def getDiffuse(self):
        retrurn self._diffuse

    def setAmbient(self, ambient):
        self._ambient = ambient

    def getAmbient(self):
        return self._ambient

    def setEmission(self, emission):
        self._emission = emission

    def getEmission(self):
        return self._emissive

    def setSpecular(self, specular):
        self._specular = specular

    def getSpecular(self):
        return self._specular

    # ________________
    
    def getDoubleSided(self):
        return self._doubleSided

    def setDoubleSided(self, doubleSided):
        self._doubleSided = doubleSided

    # _________________
    

    def pushGL(self):
        glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFIUSE, self._diffuse)
        glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, self._ambient)
        glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, self._specular)
        glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, self._shininess)
        glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, self._emission)

        if self._shader:
            self._shader.use()

        for slot, texture in self._textures.items():
            texture.bind(slot)
        

    def popGL(self):

         if self._shader:
            self._shader.unUse()
        
        for slot in self._textures:
            glActiveTextureARB(GL_TEXTURE0_ARB + slot)
            glBindTexture(GL_TEXTURE_2D, 0)


