from PIL import Image
from PIL import TgaImagePlugin

import alphaconv

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
from glew import *


class Texture:

    def __init__(self, filename):
        self.size = None

        image = Image.open(filename)
        self._texture = glGenTextures(1)
        self._texture_image_2d(image, True)
        self.bind()
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR)
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)


    def _texture_image_2d(self, image, mipmap):
        self.bind()

        if image.mode == 'RGB':
            data = image.tostring("raw","RGBX",0,-1)[:]
        elif image.mode == 'RGBA':
            data = image.tostring("raw","RGBA",0,-1)[:]
        else:
            assert False, image.mode

        width, height = image.size
#        print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
#        print width, height
        dcopy = data[:]
        alphaconv.convert(dcopy, width, height)
        data =dcopy
            
        if mipmap:
            gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, width, height,
                              GL_RGBA, GL_UNSIGNED_BYTE, data)
        else:
            glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, width, height,
                         0, GL_RGBA, GL_UNSIGNED_BYTE, data)


        self.size = image.size[:]

    def bind(self, slot = 0):
        glActiveTextureARB(GL_TEXTURE0_ARB + slot)
        glBindTexture(GL_TEXTURE_2D, self._texture)

