
import glew
import time

import OpenGL.GL
from OpenGL.GL import glClearColor

def stupidhack():
    #print "HACK"
    OpenGL.GL.glGetBoolean( OpenGL.GL.GL_BLEND )
    # glClearColor(0.2,0.2,0.2,0)
    #print "ENDHACK"


class glewInternalGLError(Exception):
    pass

class ShaderCompileError(Exception):
    pass


class GLSLShader(object):
    def __init__(self, vertexshader=None, fragmentshader=None ):
        """ NOTE THAT VERTEX/FRAGMENT SHADER SHOULD BE A LIST OF STRINGS!"""
        self.usable = False
        self.vertexshaderfile = None
        self.fragmentshaderfile = None
        self.vertexshader = None
        self.fragmentshader = None
        
        if isinstance( vertexshader , str ) and len(vertexshader.splitlines())==1:
            # print "Treating shader with contents '%s' as a filename" % vertexshader
            # treat arguments as a filename
            self.vertexshaderfile = vertexshader
        else:
            self.vertexshader = vertexshader

        if isinstance( fragmentshader , str ) and len(fragmentshader.splitlines())==1:
            # treat arguments as a filename
            self.fragmentshaderfile = fragmentshader
        else:
            self.fragmentshader = fragmentshader
        
        self.compiled = False

    def compile(self):
        if self.vertexshader is not None:
            self.hVertexProgram = glew.glCreateShaderObjectARB(glew.GL_VERTEX_SHADER_ARB);
            self.checkErrors()
            # print "hoiV", self.hVertexProgram
            glew.glShaderSourceARB(self.hVertexProgram, len(self.vertexshader), self.vertexshader );
            self.checkErrors()
            glew.glCompileShaderARB(self.hVertexProgram);
            self.checkErrors()
            

        if self.fragmentshader is not None:
            self.hFragmentProgram = glew.glCreateShaderObjectARB(glew.GL_FRAGMENT_SHADER_ARB);
            self.checkErrors()
            # print "hoiF", self.hFragmentProgram
            glew.glShaderSourceARB(self.hFragmentProgram, len(self.fragmentshader), self.fragmentshader );
            self.checkErrors()
            glew.glCompileShaderARB(self.hFragmentProgram);
            self.checkErrors()
            
        self.hShaderProgram = glew.glCreateProgramObjectARB();
        self.checkErrors()
        if self.vertexshader is not None:
            glew.glAttachObjectARB(self.hShaderProgram,self.hVertexProgram);
            self.checkErrors()
        if self.fragmentshader is not None:
            glew.glAttachObjectARB(self.hShaderProgram,self.hFragmentProgram);
            self.checkErrors()

        glew.glLinkProgramARB(self.hShaderProgram);
        self.checkErrors()
        glew.glValidateProgramARB(self.hShaderProgram);
        self.checkErrors()
        self.checkStatus();
        stupidhack()
        print "hoiDone"
        if self.usable:
            print "checking  available  uniforms in shader program..."
            print "in hShaderProgram:"
            print "GL_OBJECT_ACTIVE_UNIFORMS_ARB: ",glew.glGetObjectParameterivARB( self.hShaderProgram, glew.GL_OBJECT_ACTIVE_UNIFORMS_ARB )
            paramlist = []
            for paramnr in range( glew.glGetObjectParameterivARB( self.hShaderProgram, glew.GL_OBJECT_ACTIVE_UNIFORMS_ARB ) ):
                param = glew.glGetActiveUniformARB( self.hShaderProgram, paramnr )
                paramlist.append(param)
                print "PARAMS EXTRACTED:",param
                #self.addParam( *param )
            print "Uniforms in paramlist:",paramlist
            print "GL_OBJECT_ACTIVE_ATTRIBUTES_ARB: ",glew.glGetObjectParameterivARB( self.hShaderProgram, glew.GL_OBJECT_ACTIVE_ATTRIBUTES_ARB )
            for paramnr in range( glew.glGetObjectParameterivARB( self.hShaderProgram, glew.GL_OBJECT_ACTIVE_ATTRIBUTES_ARB ) ):
                param = glew.glGetActiveAttribARB( self.hShaderProgram, paramnr,1000 )
                print "ATTRIBUTE EXTRACTED (ignoring):",param
            self.addParams(paramlist)

    def addParams( self, paramlist ):
        slotdict = {}
        plist = []
        for (datasize, datatype, name) in paramlist:
            print "datatype:",datatype
            print "datasize:",datasize
            print "name:",name
            # print "glew.GL_FLOAT:", glew.GL_FLOAT
            print "retrieving reference"
            ref = glew.glGetUniformLocationARB(self.hShaderProgram, name )
            print "ref=",ref
            if ref==-1:
                print "unable to retrieve a reference to '"+name+"'... ignoring"
                continue

            if datatype==glew.GL_FLOAT:
                def getter(self,ref=ref):
                    # sorry, this seems to be the ATI way to do things.
                    return glew.glGetUniformfv( self.hShaderProgram, ref, 1 )[0]
                    # and this is for nvidia?
                    return glew.glGetUniformfvARB( self.hShaderProgram, ref )
                def setter(self,v,ref=ref):
                    glew.glUniform1fARB( ref, v )
            elif datatype==glew.GL_FLOAT_VEC2_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 2 )
                def setter(self,v,ref=ref):
                    glew.glUniform2fARB( ref, v[0],v[1] )
            elif datatype==glew.GL_FLOAT_VEC3_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 3 )
                def setter(self,v,ref=ref):
                    glew.glUniform3fARB( ref, v[0],v[1],v[2] )
            elif datatype==glew.GL_FLOAT_VEC4_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 4 )
                def setter(self,v,ref=ref):
                    glew.glUniform3fARB( ref, v[0],v[1],v[2],v[3] )
            elif datatype==glew.GL_SAMPLER_2D:
                def getter(self,ref=ref):
                    # again, an ati hack. doenst work
                    return None
                    return glew.glGetUniformivARB( self.hShaderProgram, ref  )
                    # for nvidia
                    return glew.glGetUniformiv( self.hShaderProgram, ref , 1 )[0]
                def setter(self,v,ref=ref):
                    glew.glUniform1iARB( ref, v )
            elif datatype==glew.GL_SAMPLER_3D:
                def getter(self,ref=ref):
                    return glew.glGetUniformiv( self.hShaderProgram, ref , 1 )[0]
                def setter(self,v,ref=ref):
                    glew.glUniform1iARB( ref, v )
            elif datatype==glew.GL_INT:
                print "glew.GL_INT datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_INT_VEC2_ARB:
                print "glew.GL_INT datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_INT_VEC3_ARB:
                print "glew.GL_INT datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_INT_VEC4_ARB:
                print "glew.GL_INT datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_BOOL_ARB:
                print "glew.GL_BOOL datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_BOOL_VEC2_ARB:
                print "glew.GL_BOOL datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_BOOL_VEC3_ARB:
                print "glew.GL_BOOL datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_BOOL_VEC4_ARB:
                print "glew.GL_BOOL datatype currently unsupported! skipping"
                continue
            elif datatype==glew.GL_FLOAT_MAT2_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 4 )
                def setter(self,v,ref=ref):
                    glew.glUniformMatrix2fvARB(ref, 1, False, v )
            elif datatype==glew.GL_FLOAT_MAT3_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 9 )
                def setter(self,v,ref=ref):
                    glew.glUniformMatrix3fvARB(ref, 1, False, v )
            elif datatype==glew.GL_FLOAT_MAT4_ARB:
                def getter(self,ref=ref):
                    return glew.glGetUniformfv( self.hShaderProgram, ref , 16 )
                def setter(self,v,ref=ref):
                    glew.glUniformMatrix4fvARB(ref, 1, False, v )
            else:
                print "unknown datatype (",datatype,"), skipping!"
                continue

            # ok this does not work, but we have a little trick up our sleeve

            #         def getter(self):
            #             return self.__value
            #         def setter(self, v):
            #             self.__value = v
            #             glew.glUniformARB1f( ref, v ) # or something rather

            #         setattr( self, name, property( getter, setter ) )
            
            slotdict[name] = property(getter,setter)
            plist += [ {'name' : name, 'datatype' : datatype, 'getter' : getter, 'setter' : setter} ]
        class UniformContainer(object):
            def __init__(self, hShaderProgram):
                self.hShaderProgram = hShaderProgram

        slotdict["__init__"] = lambda self,*args,**kwargs : UniformContainer.__init__(self,*args,**kwargs)
        slotdict["magic"] = slotdict
        slotdict["__getitem__"] = lambda self,key : self.magic[key].fget(self)
        slotdict["__setitem__"] = lambda self,key,value : self.magic[key].fset(self,value)
        slotdict["__paramlist__"] = plist

        #print "ADDING DICT SLOTDICT:",slotdict
        self.uniforms = type('uniformHack', (UniformContainer,),
                             slotdict )(self.hShaderProgram)

    def checkErrors(self):
        err = glew.glGetError()
        if (err):
            error = glewInternalGLError("gl error: "+OpenGL.GLU.gluErrorString( err ) )
            print error
            raise error
            pass
    

    def checkStatus(self):
        logtext = ""
        self.usable = True
        try:
            if self.vertexshader is not None:
                # print "vertexprogramref:",self.hVertexProgram
                logtext += glew.glGetInfoLogARB( self.hVertexProgram )
                self.checkErrors()

                compilestatus = glew.glGetObjectParameterivARB(self.hVertexProgram, glew.GL_OBJECT_COMPILE_STATUS_ARB);
                if compilestatus != 1:
                    print "vcompilestatus = ",compilestatus
                    raise ShaderCompileError( "failed to compile vertex shader:"+logtext)

                #glew.glValidateProgramARB( self.hVertexProgram );
                #self.checkErrors()
                #status = glew.glGetObjectParameterivARB( self.hVertexProgram , glew.GL_OBJECT_VALIDATE_STATUS_ARB )
                #self.checkErrors()
                #if (status):
                #    logtext+="[vertexshader valid]";
                #else:
                #    logtext+="[vertexshader INVALID]";
        except glewInternalGLError:
            #print "failed to compile vertexshader"
            self.usable = False
            raise ShaderCompileError( "failed to compile vertexshader:"+logtext )

        try:
            if self.fragmentshader is not None:
                #print "fragmentprogramreff:",self.hFragmentProgram
                logtext += glew.glGetInfoLogARB( self.hFragmentProgram );
                self.checkErrors()
                compilestatus = glew.glGetObjectParameterivARB(self.hFragmentProgram, glew.GL_OBJECT_COMPILE_STATUS_ARB);
                if compilestatus != 1:
                    print "fcompilestatus = ",compilestatus
                    raise ShaderCompileError( "failed to compile fragment shader:"+logtext)
                #glew.glValidateProgramARB(self.hFragmentProgram );
                #self.checkErrors()
                #status = glew.glGetObjectParameterivARB( self.hFragmentProgram , glew.GL_OBJECT_VALIDATE_STATUS_ARB )
                #self.checkErrors()
                #if (status):
                #    logtext+="[fragmentshader valid]";
                #else:
                #    logtext+="[fragmentshader INVALID]";
        except glewInternalGLError:
            #print "failed to compile fragmentshader"
            self.usable = False
            raise ShaderCompileError( "failed to compile fragment shader:"+logtext )

        try:
            # print "shaderprogramref:",self.hShaderProgram
            logtext += glew.glGetInfoLogARB( self.hShaderProgram );
            self.checkErrors()

            glew.glValidateProgramARB(self.hShaderProgram );
            self.checkErrors()
            status = glew.glGetObjectParameterivARB( self.hShaderProgram , glew.GL_OBJECT_VALIDATE_STATUS_ARB )
            self.checkErrors()
            print "status=",status
            if status!=1: # 1 = success
                print "OEI:", ShaderCompileError('failed to link shader:'+logtext)
                pass # hack

        except glewInternalGLError:
            print "failed to link shader"
            self.usable = False
            raise

        if not self.usable:
            print "Failures after compiling/linking phase that make the shader unusable:{"+logtext+"}"
            # we could raise a nice exception here
        else:
            print "DEBUG: produced a usable shader, statustext=",logtext
        #print "checkErrors:",logtext

    # unfinished
#    def updateFromFile(self):
#        # (mode, ino, dev, nlink, uid, gid, size, atime, mtime, ctime)
#        s = os.stat( self.filename )

    def freeze(self):
        "prevent dynamics updates from occuring on this shader"
        self.checkForFileUpdates()
        self.vertexshaderfile = None
        self.fragmentshaderfile = None

    def usingFileShaders( self ):
        return self.vertexshaderfile is not None or self.fragmentshaderfile is not None

    def checkForFileUpdates( self ):
        renewed = False
        if self.vertexshaderfile is not None:
            newshader = file( self.vertexshaderfile, "rb" ).readlines()
            if self.vertexshader != newshader:
                self.compiled = False
                self.vertexshader = newshader
                renewed = True

        if self.fragmentshaderfile is not None:
            newshader = file( self.fragmentshaderfile, "rb" ).readlines()
            if self.fragmentshader != newshader:
                self.compiled = False
                self.fragmentshader = newshader
                renewed = True

        return renewed

    
    def use(self):
        self.checkForFileUpdates()

# freeze when compilation fails. allow user to fix the shader
        if not self.compiled:
            while not self.compiled:
                print "shader",self,"is now in use.. compiling.."
                try:
                    self.compile()
                    self.compiled = True
                except Exception, e:
                    print "compilation of shader failed:",e
                    if not self.usingFileShaders():
                        raise

                    print "^"*40
                    print "SHADER",self.vertexshaderfile,self.fragmentshaderfile,"FAILED TO COMPILE, PLEASE CORRECT THIS"
                    while not self.checkForFileUpdates():
                            time.sleep(0.2)
                #self.compiled = False
                #self.usable = False
                #self.addParams([])
                
#         if not self.compiled:
#             print "shader",self,"is now in use.. compiling.."
#             try:
#                 self.compile()
#                 self.compiled = True
#             except Exception, e:
#                 print "compilation of shader failed:",e
#                 if not self.usingFileShaders():
#                     raise
#                 self.compiled = False
#                 self.usable = False
#                 self.addParams([])

            print "compile done"

        if not self.usable:
            print "Warning! shader is not usable!"
            return
        glew.glUseProgramObjectARB(self.hShaderProgram)
        self.checkErrors()

    def unUse(self):
        if not self.usable:
            print "Warning! shader is not usable!"
            return
        glew.glUseProgramObjectARB(0)
        self.checkErrors()

    def getReference(self, varname):
        """TODO: check whether the shader is actually in use! otherwise this code won't work"""
        if not self.usable:
            print "Warning! shader is not usable!"
            return
        loc = glew.glGetUniformLocationARB(self.hShaderProgram, varname );
        self.checkErrors()
        return loc
