from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import random
from math import cos
from glew import *

from texture import Texture
from shader import GLSLShader
from fbo import FBO

""" A really slow particle system in pure python, only use this for really small amounts of particles
"""


class Particle:

    def __init__(self):

        self.position = [random.random(), 0, random.random()]
        self.velocity = [0.0, random.random(), 0.0]

        c = random.random()

        if c < .5:
            c = 0
        else:
            c = 1

        if c == 0:
            self.opacity = 1.0
        else:
            self.opacity = .5
        

        self.color = [c,c,c]
        
        self.ttl = 0
        self.maxage = 1




    def update(self, time, delta):
        self.position[0] += self.velocity[0] * delta
        self.position[1] += self.velocity[1] * delta
        self.position[2] += self.velocity[2] * delta
        self.ttl -= delta

        self.velocity[0] += cos(self.position[1]) * 0.019



        spread = 10

        if self.ttl < 0:
            self.ttl = random.random() * 10
            self.maxage = self.ttl
            self.position = [spread * (random.random()-.5), -4, spread * (random.random()-.5 )]
            self.velocity = [0.0, random.random()+ 1.0, 0.0]
            
class ParticleSystem:

    def __init__(self, screenDim):
        self._screenDim = screenDim
        
        self.particles = []
        for i in xrange(100):
            self.particles.append(Particle())

        self.distort = 0

        self.texture = Texture("data/cirkeltje.png")
        glTexEnvi(GL_POINT_SPRITE, GL_COORD_REPLACE, GL_TRUE)
        self.fbo = FBO(*self._screenDim)
        
        self.pointShader = GLSLShader(vertexshader = [
            """
            varying vec2 tc;
            varying vec4 col;

            void main() {
                gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
                gl_PointSize = cos(gl_Position.y)*5.0+5.0;
                tc = vec2(0,0);
                col.rgba = gl_Color;
            }

            """],
                                      fragmentshader = [
            """
            uniform sampler2D T0;
            uniform sampler2D T1;

            varying vec2 tc;
            varying vec4 col;
            void main(void) {
                vec4 screenCol = texture2D(T0,  tc);
                gl_FragColor.rgba = screenCol;
                gl_FragColor.r += .2;
            }
            """])
            
                    
        self.pointShader.compile()

            

    def update(self, time, delta):
        for particle in self.particles:
            particle.update(time, delta)

    def draw(self, time, delta):

        #glEnable(GL_POINT_SMOOTH)
        self.fbo.bindAsTexture()
        glCopyTexSubImage2D(GL_TEXTURE_2D, 0, 0, 0, 0, 0, self._screenDim[0], self._screenDim[1])

        self.pointShader.use()
                
    
        glDepthMask(False)

        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        glEnable(GL_BLEND)

        glEnable(GL_POINT_SPRITE_NV)


        self.texture.bind()
        glEnable(GL_TEXTURE_2D)
        glEnable(GL_VERTEX_PROGRAM_POINT_SIZE_ARB)


        glPointSize(15)
        glDisable(GL_LIGHTING)
        glBegin(GL_POINTS)
        
       
        for particle in self.particles:


#            if self.distort > .1:
#                particle.velocity[1] -= .2
            
            
            c = particle.ttl
            c = min(c, 1)
             
            glColor4f(particle.color[0], particle.color[1], particle.color[2], c * particle.opacity)
            glVertex3f(particle.position[0], particle.position[1], particle.position[2])
            glNormal3f(particle.position[0], particle.position[1], particle.position[2])

        glEnd()
        glDisable(GL_BLEND)
#        glDisable(GL_POINT_SMOOTH)
        glDisable(GL_POINT_SPRITE_NV)
        glDisable(GL_VERTEX_PROGRAM_POINT_SIZE_ARB)
        glBindTexture(GL_TEXTURE_2D, 0)

        glDisable(GL_TEXTURE_2D)
        glDepthMask(True)
        self.pointShader.unUse()
        
    
    
