from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
import glew

# i've been trying to follow http://www.gamedev.net/community/forums/topic.asp?topic_id=331734
# but it just doesnt seem to work.
import sys

from glew import *

class FBOError(Exception):
    def __init__(self, *args):
        Exception.__init__(self,args)

class Buffer(object):
    "base buffer class, can be either a texture or a renderbuffer"
    def __init__(self):
        pass

class RenderBuffer(Buffer):
    "renderbuffer is a Buffer that will only be used as a render target, ie will not be used as a texture (inside a FBO)"
    def __init__(self,width,height):
        Buffer.__init__(self)
        self.id = glGenRenderbuffersEXT(1)[0]

class TextureBuffer(Buffer):
    "TextureBuffer is a Buffer which can be used as a texture and as a render target (inside a FBO)"
    def __init__(self,width,height):
        Buffer.__init__(self)
        self.id = glGenTextures(1)
        self.bind()
        glPixelStorei( GL_UNPACK_ALIGNMENT , 1 )
        ix = width
        iy = height
        leeg = "abcd"*ix*iy
        glTexImage2D(GL_TEXTURE_2D, 0, 4, ix, iy, 0, GL_RGBA, GL_UNSIGNED_BYTE, leeg )
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP )
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP )
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST )
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST )

        glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE )
        self.unbind()

    def bind(self):
        glBindTexture(GL_TEXTURE_2D, self.id )

    def unbind(self):
        glBindTexture(GL_TEXTURE_2D, 0 )

class FBO(object):
    def __init__(self, width = 512, height = 512, colorbuffers=[None], depthbuffer=True ):
        self.width = width
        self.height = height
        self.framebuffer = glGenFramebuffersEXT(1)[0]
        if depthbuffer == True:
            self.depthbuffer = RenderBuffer(width,height)
        elif depthbuffer == False:
            self.depthbuffer = None
        else:
            self.depthbuffer = depthbuffer

        self.textures = []
        for c in colorbuffers:
            if c is None:
                self.textures.append( TextureBuffer(width,height) )
            else:
                self.textures.append( c )
        
        glBindFramebufferEXT( GL_FRAMEBUFFER_EXT, self.framebuffer )
        
        # texture initialization is done by the texture objects upon construction.

        # attach textures to framebuffer color buffers
        cnt = 0
        for texture in self.textures:
            ret = glFramebufferTexture2DEXT( GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT+cnt, GL_TEXTURE_2D , texture.id, 0 )
            cnt += 1
    
        # init depth buffer
        if self.depthbuffer is not None:
            # fixme: these two lines could probably be performed by the RenderBuffer constructor
            glBindRenderbufferEXT( GL_RENDERBUFFER_EXT, self.depthbuffer.id )
            glRenderbufferStorageEXT( GL_RENDERBUFFER_EXT, GL_DEPTH_COMPONENT32, self.width, self.height )
    
            # attach renderbuffer to framebuffer depth buffer
            glFramebufferRenderbufferEXT(GL_FRAMEBUFFER_EXT, GL_DEPTH_ATTACHMENT_EXT,
                                         GL_RENDERBUFFER_EXT, self.depthbuffer.id)
    
        # fixme: make sure to check framebuffer status here
        status = glCheckFramebufferStatusEXT( GL_FRAMEBUFFER_EXT )
        if status != GL_FRAMEBUFFER_COMPLETE_EXT:
            if status == GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT:
                raise FBOError( "incomplete attachment" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT:
                raise FBOError(  "duplicate attachment" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT:
                raise FBOError( "incompleter read buffer" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT:
                raise FBOError( "incomplete dimensions" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT:
                raise FBOError( "incomplete formats" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT:
                raise FBOError( "incomplete draw buffer" )
            elif status == GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT:
                raise FBOError( "missing attachment" )
            else:
                raise FBOError( "unknown error number:"+str(status) )
            
        # and we're set.
        self.unbindAsRenderTarget()

    def bindAsRenderTarget(self):
        # render to FBO
        glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, self.framebuffer );
        glViewport(0,0,self.width,self.height)

    def unbindAsRenderTarget(self):
        # render to normal output
        glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0 );
        
    def bindAsTexture(self, colorbufferNr = 0, slot = 0):
        glActiveTextureARB(GL_TEXTURE0_ARB + slot)
        self.textures[colorbufferNr].bind()
        #         for texture in self.textures:
        #             glActiveTextureARB( GL_TEXTURE0_ARB + cnt )
        #             cnt += 1
        #             texture.bind()

    def drawToScreen(self):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        self.textures[0].bind()
        glEnable(GL_TEXTURE_2D)
        glDisable(GL_BLEND)
        glBegin(GL_QUADS)
        glColor3f(1,1,1)
        glTexCoord2f(1,0)
        glVertex2f(1,-1)
        glTexCoord2f(1,1)
        glVertex2f(1,1)
        glTexCoord2f(0,1)
        glVertex2f(-1,1)
        glTexCoord2f(0,0)
        glVertex2f(-1,-1)
        glEnd()
        glDisable(GL_TEXTURE_2D)

def test():
    width = 256
    height = 256
        
    # create objects
    framebuffer = glGenFramebuffersEXT(1)[0]
    depthbuffer = glGenRenderbuffersEXT(1)[0]
    textureId = glGenTextures(1)
    glBindFramebufferEXT( GL_FRAMEBUFFER_EXT, framebuffer )
    

    # initialize texture
    glBindTexture( GL_TEXTURE_2D, textureId )
    
    glPixelStorei( GL_UNPACK_ALIGNMENT , 1 )
    ix = width
    iy = height
    leeg = "abcd"*ix*iy
    #glTexImage2D(GL_TEXTURE_2D, 0, 4, ix, iy, 0, glew.GL_FLOAT_RGB32_NV, GL_UNSIGNED_BYTE, leeg)
    glTexImage2D(GL_TEXTURE_2D, 0, 4, ix, iy, 0, GL_RGBA, GL_UNSIGNED_BYTE, leeg)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR)
    glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE )

    
    glBindTexture(GL_TEXTURE_2D, 0 )

    # attach texture to framebuffer color buffer
    ret = glFramebufferTexture2DEXT( GL_FRAMEBUFFER_EXT, GL_COLOR_ATTACHMENT0_EXT, GL_TEXTURE_2D , textureId, 0 )
    
    # init depth buffer
    glBindRenderbufferEXT( GL_RENDERBUFFER_EXT, depthbuffer )
    glRenderbufferStorageEXT( GL_RENDERBUFFER_EXT, GL_DEPTH_COMPONENT24, width, height )
    
    # attach renderbuffer to framebuffer depth buffer
    glFramebufferRenderbufferEXT(GL_FRAMEBUFFER_EXT, GL_DEPTH_ATTACHMENT_EXT,
                                 GL_RENDERBUFFER_EXT, depthbuffer)
    
    # fixme: make sure to check framebuffer status here
    status = glCheckFramebufferStatusEXT( GL_FRAMEBUFFER_EXT )
    if status != GL_FRAMEBUFFER_COMPLETE_EXT:
        print "error!"
        if status == GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT:
            print "incomplete attachment"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT:
            print "duplicate attachment"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT:
            print "incompleter read buffer"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT:
            print "incomplete dimensions"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT:
            print "incomplete formats"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT:
            print "incomplete draw buffer"
        elif status == GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT:
            print "missing attachment"
        else:
            print "unknown error number:",status
    else:
        print "framebuffer complete!"
    
    print "fbstatus=",status

    # render to FBO
    glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, framebuffer );
    
    glClearColor(0,0,0,0)
    glDrawBuffer ( GL_COLOR_ATTACHMENT0_EXT );
    glClearColor(1,0,1,0)
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )
    glMatrixMode(GL_PROJECTION)
    glViewport(0,0,width,height)
    glLoadIdentity()

    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    # glDisable(GL_DEPTH_TEST)
    #    glTranslatef(0,0,-0.4)
    glDisable(GL_TEXTURE_2D)
    glBegin(GL_QUADS)
    
    glColor3f(1,0,0)
    glVertex2f(1,0)
    glVertex2f(1,1)
    glVertex2f(0,1)
    glVertex2f(0,0)
    
    glColor3f(1,1,0)
    glVertex2f(.1,0)
    glVertex2f(.1,.1)
    glVertex2f(0,.1)
    glVertex2f(0,0)
    glEnd()
    glBegin(GL_TRIANGLES)
    glVertex2f(0,0)
    glVertex2f(-1,-1)
    glVertex2f(-0.9,-1)
    glEnd()
    
    # glClear( GL_COLOR_BUFFER_BIT )

    glBindFramebufferEXT(GL_FRAMEBUFFER_EXT, 0)
    return textureId
    
    
