from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

import glew
import array
import pygame


class VertexArray:
    def __init__( self , slot ):
        self.data = []
        self.array = array.array('f')
        self.slot = slot
        self.itemsize = None
        self.vbuffer = glew.glGenBuffersARB(1)[0]

        import ctypes
        #cd= ctypes.cdll.LoadLibrary('/usr/lib/libGL.so')
        # func = cdll.glVertexPointer(

        #self.horridHack = cd.glVertexPointer
        #self.horridHack.argtypes = [ ctypes.c_int, ctypes.c_int, ctypes.c_int, ctypes.c_void_p ]

        #cdll=ctypes.cdll.LoadLibrary( './test.so' )
        #self.horridHack = cdll.thecall
        pass

    def addVector( self, item ):
        if self.itemsize is None:
            self.itemsize = len(item)
        else:
            if len(item) != self.itemsize:
                raise RuntimeException("VertexArray::addElement should always be given elements of the same size")
        self.data += [ item ]
        self.array.extend( item )
        self.modified = True

    def bind( self, slot = None ):
        if slot is None:
            slot = self.slot

            
        glew.glBindBufferARB( glew.GL_ARRAY_BUFFER_ARB, self.vbuffer )
        if self.modified:
            lamestring = self.array.tostring()
            print len(self.array)*self.array.itemsize,len(lamestring)
            glew.glBufferDataARB( glew.GL_ARRAY_BUFFER_ARB, len(lamestring), lamestring, glew.GL_STATIC_DRAW_ARB);
            self.modified = False

        if slot == GL_COLOR_ARRAY:
            glColorPointerf( self.data )
        elif slot == GL_VERTEX_ARRAY:
            #glVertexPointerf( self.data )
            glVertexPointer( self.itemsize , GL_FLOAT, 0, 0 )
            # self.horridHack( self.itemsize, GL_FLOAT, 0, None )
            # self.horridHack( 3, GL_FLOAT, "HENK", None )
            #self.horridHack()
            # print glGetPointerv( GL_VERTEX_ARRAY_POINTER )
        else:
            raise RuntimeException("VertexArray::bind should take GL_COLOR_ARRAY or GL_VERTEX_ARRAY as argument")

        glEnableClientState( slot  )

    def unbind( self, slot = None ):
        if slot is None:
            slot = self.slot
        # is this necessary? glColorPointerf( None )
        glDisableClientState( slot )

    def draw( self , mode = GL_POINTS):
        self.bind()
        glDrawArrays( mode, 0, len( self.data ) )
        self.unbind()
