from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

import glew

import pygame


class Texture:
    def __init__(self, size=None, internalformat = None ):
        self.texnr = glGenTextures(1)

        # todo: if size is None, look for a filename 
        self.size = size

        self.bind()
        glTexParameterf( glew.GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST )
        glTexParameterf( glew.GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST )
        glTexParameterf( glew.GL_TEXTURE_2D, glew.GL_TEXTURE_WRAP_S, GL_CLAMP )
        glTexParameterf( glew.GL_TEXTURE_2D, glew.GL_TEXTURE_WRAP_T, GL_CLAMP )
        glTexParameterf( glew.GL_TEXTURE_2D, glew.GL_TEXTURE_WRAP_R, GL_CLAMP )
        # this could be modulate. depends on the use
        glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE )

        #upload initial image. pick some random color
        if internalformat is None:
            internalformat = GL_RGBA
        glTexImage2D( glew.GL_TEXTURE_2D, 0, internalformat , self.getWidth(),self.getHeight(), 0, 
            GL_RGBA , GL_UNSIGNED_BYTE, 'A a@'*self.getWidth()*self.getHeight() )

        # this is updated when subsurface updates are being used
        self.maxtexcoord = ( 1.0 , 1.0 )


    def getWidth(self):
        return self.size[0]

    def getHeight(self):
        return self.size[1]

    def updateFromSurface(self, surf ):
        textureData = pygame.image.tostring(surf , "RGBA", 0 )
        glEnable(glew.GL_TEXTURE_2D)
        self.bind()
        width, height = surf.get_size()
        glTexSubImage2D( glew.GL_TEXTURE_2D, 0, 0,0, width, height, 
            GL_RGBA, GL_UNSIGNED_BYTE, textureData )

        utex = width/float(self.getWidth())
        vtex = height/float(self.getHeight())
        self.maxtexcoord = ( utex, vtex )
        
    def bind(self, textureUnit = None):
        if textureUnit is not None:
            glew.glActiveTextureARB( glew.GL_TEXTURE0_ARB + textureUnit )

        glEnable( glew.GL_TEXTURE_2D )
        glBindTexture( glew.GL_TEXTURE_2D, self.texnr )

    def draw(self, frame=(-1,1 ,1,-1), texcoordframe=None): # THIS NEEDS TO BE FIXED. coordinates are 'upside down' needed for FBO operations
        """frame is optional, it is a 4-tuple with x1,y1, x2,y2 stating the coordinates of the quad that is drawn
        texcoordframe is the same but then in texture coordinates (for cropping and such)"""
        utexmax = self.maxtexcoord[0]
        vtexmax = self.maxtexcoord[1]
        utexmin = 0.0
        vtexmin = 0.0
        if texcoordframe is not None:
            utexmin = texcoordframe[0] * self.maxtexcoord[0] / self.getWidth()
            utexmax = texcoordframe[2] * self.maxtexcoord[0] / self.getWidth()
            vtexmin = texcoordframe[1] * self.maxtexcoord[1] / self.getHeight()
            vtexmax = texcoordframe[3] * self.maxtexcoord[1] / self.getHeight()
        self.bind()
        glBegin(GL_QUADS)
        glTexCoord2f(utexmin,vtexmax)
        glVertex2f(frame[0],frame[1])
        glTexCoord2f(utexmax,vtexmax)
        glVertex2f(frame[2],frame[1])
        glTexCoord2f(utexmax,vtexmin)
        glVertex2f(frame[2],frame[3])
        glTexCoord2f(utexmin,vtexmin)
        glVertex2f(frame[0],frame[3])
        glEnd()
