

try:
    from cgkit.cgtypes import *
except:
    print "toet"
    
# from cgtypes import *

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

import glew
import sys
import os
import math
import os.path

from texture import Texture
from shader import GLSLShader
from display import Display
from fbo import FBO

import pygame.image
import random


particlestoresize = (64,512 )

# order is important here. you should init glew once you have a display!
d = Display( 512, 512 )
glew.glewInit() 

iformat = glew.GL_RGB # _FLOAT32_ATI
iformat = glew.GL_FLOAT_RGBA16_NV
iformat = glew.GL_RGBA32F_ARB

fbo = FBO( particlestoresize[0], particlestoresize[1], colorbuffers = [ Texture( (particlestoresize[0], particlestoresize[1] ), internalformat = iformat )] )
running = True

motionfield = Texture( (512,512 ) )
pic = pygame.image.load('pic.jpg')
motionfield.updateFromSurface( pic )

particles = Texture( particlestoresize, internalformat = iformat )
#particlefbo = FBO( particlestoresize[0], particlestoresize[1] , colorbuffers = [ particles ] )

randomlocations = pygame.Surface( particlestoresize )
for x in range( randomlocations.get_width() ):
    for y in range( randomlocations.get_height() ):
        randomlocations.set_at( (x,y), (random.randint(0,255), random.randint(0,255), 0 ) )
particles.updateFromSurface( randomlocations )

particleupdater = GLSLShader(vertexshader = 'particles.vert', fragmentshader = 'particles.frag' )



import time

c = pygame.time.Clock()
frame = 0

while running:
    d.clear()
    d.loadOrtho()

    c.tick()
    frame += 1
    if frame % 100 == 0:
        print "fps:",c.get_fps()
    #time.sleep(.02)

    fbo.bindAsRenderTarget()

    particles.bind( textureUnit = 1 )
    motionfield.bind( textureUnit = 0 )
    particleupdater.use()
    particleupdater.uniforms.tex = 0
    particleupdater.uniforms.motiontex = 1
    particleupdater.uniforms.offset = 0.05*c.get_time()
    particles.draw()
    particleupdater.unUse()

    glReadBuffer( glew.GL_COLOR_ATTACHMENT0_EXT )
    glPixelStorei( GL_PACK_ALIGNMENT, 1 )
    newlocations = glReadPixelsf ( 0, 0, particlestoresize[0], particlestoresize[1] , GL_RGB )
    # newlocations = None
    # print newlocations
    particles.bind( textureUnit = 0 )
    glCopyTexImage2D( GL_TEXTURE_2D, 0, iformat, 0, 0, particlestoresize[0], particlestoresize[1] , 0 )
    
    fbo.unbindAsRenderTarget()
    glViewport( 0, 0, 512, 512 )


    # this is a mess, should be abstracted!
    glew.glActiveTextureARB( glew.GL_TEXTURE1_ARB )
    glBindTexture(GL_TEXTURE_2D, 0 )
    glDisable(GL_TEXTURE_2D)
    glew.glActiveTextureARB( glew.GL_TEXTURE0_ARB )
    glBindTexture(GL_TEXTURE_2D, 0 )
    glDisable(GL_TEXTURE_2D)
    motionfield.draw()

    d.loadOrtho()
    glScalef( 2.0, 2.0, 1.0 )
    glTranslatef( -0.5, -0.5,  0.0)
    glDisable(GL_TEXTURE_2D)
    glColor3f(1,1,1)
    x=0
    glEnable(GL_POINT_SMOOTH)
    glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA )
    if newlocations is not None:
        for line in newlocations:
            x+=1
            y=0
            glVertexPointerf( line )
            glPointSize( 1 + (x%10) )
            glColor3f( 0.5+0.5*math.sin(x), 0.5+0.5*math.sin(x), 0.6+0.4*math.sin(x))
            glEnableClientState( GL_VERTEX_ARRAY )
            glDrawArrays( GL_POINTS, 0, particlestoresize[1] )
            glDisableClientState( GL_VERTEX_ARRAY )
    d.flip()

