from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *


from Dice3DS import dom3ds
from Dice3DS.example import glmodel, gltexture
from Dice3DS.example.GL import *

import sys
import pickle
import time

def load_model_from_filesystem(filename):
    texcache = {}
    def load_texture(texfilename):
        if texcache.has_key(texfilename):
            return texcache[texfilename]
        try:
            tex = gltexture.Texture(texfilename)
        except IOError:
            sys.stderr.write("Warning: can't load texture '%s'\n"
                             % texfilename)
            tex = None
        texcache[texfilename] = tex
        return tex

    stime = time.time()
    dom = dom3ds.read_3ds_file(filename)
    etime = time.time()
    print "building DOM model took",etime-stime,"seconds"
    # pickled = pickle.dumps(dom)
    #     stime = time.time()
    #     dom = pickle.loads( pickled )
    #     etime = time.time()
    #     print "depickling the DOM model takes",etime-stime,"seconds"
    stime = time.time()
    glnr =  glmodel.GLModel(dom,load_texture)
    etime = time.time()
    print "building the gl model took",etime-stime,"seconds"
    return glnr

class OLObject(object):
        def __init__(self, filename):
                self.model = load_model_from_filesystem( filename )
                self.dl = self.model.create_dl()

        def drawAmbient(self, time, delta, fade = 1.0):
                glPushAttrib( GL_LIGHTING_BIT )
                glDisable(GL_LIGHTING)
                glColor3f(fade,fade,fade)
                glPushMatrix()
                glTranslatef(0,-2.1,0)
                glRotatef(-90,1,0,0)
                glCallList(self.dl)
                glPopMatrix()
                glPopAttrib()

        def draw(self, time, delta, fade = 1.0):
                glPushAttrib( GL_LIGHTING_BIT )
                glEnable(GL_LIGHTING)
                glColor3f(fade,fade,fade)
                glPushMatrix()
                glTranslatef(0,-2.1,0)
                glRotatef(-90,1,0,0)
                glCallList(self.dl)
                glPopMatrix()
                glPopAttrib()
