import gobject
import gtk
from gtk import gtkgl
import gtk.gdk
from OpenGL import *
from OpenGL.GL import *
from OpenGL.GLUT import *

class myWidget( gtkgl.DrawingArea ):
    def __init__(self):
        glmode = gtk.gdkgl.MODE_RGBA | gtk.gdkgl.MODE_DOUBLE | gtk.gdkgl.MODE_DEPTH
    
        try:
            glconfig = gtk.gdkgl.Config( mode = glmode )
        except gtk.gdkgl.NoMatches:
            raise Exception("cannot get specified mode")

        gtk.gtkgl.DrawingArea.__init__( self, glconfig )
        print "creation"
        self.connectSignals()

    def connectSignals(self):
        #self.connect("realize", self.OnRealize)
        self.connect("expose_event", self.onExpose)
        self.connect("configure_event", self.onConfigure)
        #self.connect("button_press_event", self.OnButtonDown)
        #self.connect("button_release_event", self.OnButtonUp)
        #self.connect("motion_notify_event", self.OnMouseMove)
        #self.connect("enter_notify_event", self.OnEnter)
        #self.connect("leave_notify_event", self.OnLeave)
        #self.connect("key_press_event", self.OnKeyPress)
        #self.connect("delete_event", self.OnDestroy)
        self.add_events(gtk.gdk.EXPOSURE_MASK )
        # | gdk.BUTTON_PRESS_MASK |
        #                         gdk.BUTTON_RELEASE_MASK |
        #                         gdk.KEY_PRESS_MASK |
        #                         gdk.POINTER_MOTION_MASK |
        #                         gdk.POINTER_MOTION_HINT_MASK |
        #                         gdk.ENTER_NOTIFY_MASK | gdk.LEAVE_NOTIFY_MASK)

    def onConfigure(self,widget,event):
        glViewport( event.x,event.y,event.width,event.height )
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glOrtho( -1, 1, -1, 1, -1, 1 )

    def onExpose(self,widget,event):
        glcontext = widget.get_gl_context()
        gldrawable = widget.get_gl_drawable()

        if not gldrawable.gl_begin(glcontext):
            return
        glClearColor(1,0,0,0)
        glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT )
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        self.customDraw()
        
        if gldrawable.is_double_buffered():
            gldrawable.swap_buffers()
        else:
            glFlush()

        gldrawable.gl_end()

        return True
    
    def customDraw(self):
        glColor4f( 0.0, 0.3, 0.0, 1.0 )
        # glScalef(0.1,0.5,1)
        import random
        #glDisable(GL_CULL_FACE)
        #glDisable(GL_DEPTH_TEST)
        #glEnable(GL_BLEND)
        #glBlendFunc(GL_ONE,GL_ONE)
        
        glRotatef(slider2.get_value(),0,1,0)
        glRotatef(slider.get_value(),1,0,0)
        
        glutSolidTeapot(0.6)


class myWindow( gtk.Window ):
    def __init__(self):
        gtk.Window.__init__( self,gtk.WINDOW_TOPLEVEL )
        self.connect("destroy", lambda w: gtk.main_quit())

glutInit([""])
w = myWindow()

myw = myWidget()
box = gtk.VBox()
box.pack_start( myw , True)
label = gtk.Label('Een opengl context ding')

slider = gtk.HScale()
slider.set_range(0,100)
box.pack_end( slider, False)

slider2 = gtk.HScale()
slider2.set_range(0,100)
box.pack_end( slider2, False)

box.pack_end( label, False)
w.add(box)
box.show_all()
w.show()

print dir(myw)
def henk():
    import time
    gobject.idle_add(henk)
    myw.queue_draw()

def text():
    import random
    label.set_label( str( random.random() ) )
    gtk.timeout_add( 50, text )
    
#print "henk"
# gtk.timeout_add( 5, henk )
# henk()
henk()
text()
gtk.main()

