import pygame
from pygame.locals import *
from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *
#from glew import *
import glew
import sys

import pygame.event

class Display:
    def __init__(self,width=640,height=480, resizable = False, showFps = False):
        pygame.display.init()
        self.width = width
        self.height = height
        self.resizable = resizable
        self.showFps = showFps
        self.clock = pygame.time.Clock()
        glutInit([])
        self.screen = pygame.display.set_mode((width,height), OPENGL | DOUBLEBUF  | (RESIZABLE * self.resizable) )
        glew.glewInit()

    def handleEvents(self): 
        for event in pygame.event.get(): 
            if event.type == pygame.QUIT:
                sys.exit(0)
                return False 
            elif event.type == pygame.VIDEORESIZE:
                print "resize",event
                self.width = event.size[0]
                self.height = event.size[1]
                pygame.display.set_mode((self.width, self.height), OPENGL | DOUBLEBUF | (RESIZABLE  * self.resizable) )
                return False
        return True

    def clear(self):
        glClearColor( 1,0,0,0)
        glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT );
        glViewport( 0,0,self.width,self.height )

    def loadOrtho(self):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        glOrtho(-1,1,-1,1,-1,1)

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()

        glBegin(GL_LINES)
        glColor3f(1,0,0)
        glVertex2f(0,0)
        glVertex2f(1,1)
        glEnd()

    def loadLookAt(self, lookfrom, lookat , eye = [0,1,0 ]):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective( 45, self.width/self.height, 0.3, 30.0 )

        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        gluLookAt( lookfrom[0], lookfrom[1], lookfrom[2],
                   lookat[0], lookat[1], lookat[2],
                   eye[0], eye[1], eye[2] )

        

    def flip(self):
        pygame.display.flip()
        self.clock.tick()
        if self.showFps:
            print "fps:",self.clock.get_fps()
        self.handleEvents()

    
