uniform sampler2D frontcoordinates;
varying vec2 texcoord;
uniform float dist;

float sqr(float f)
{
  return f*f;
}

void main()
{
  vec3 col1 = texture2D( frontcoordinates, texcoord ).xyz;
  // float dist = 0.005;
  vec3 col2 = texture2D( frontcoordinates, texcoord+vec2(dist,0) ).xyz;
  vec3 col3 = texture2D( frontcoordinates, texcoord+vec2(0,dist) ).xyz;
  vec3 col4 = texture2D( frontcoordinates, texcoord+vec2(-dist,0) ).xyz;
  vec3 col5 = texture2D( frontcoordinates, texcoord+vec2(0,-dist) ).xyz;
  vec3 col6 = texture2D( frontcoordinates, texcoord+dist*normalize(vec2(1,1)) ).xyz;

  float fx = col2.x-col1.x;
  float fy = col3.x-col1.x;
  float fxx = (col2.x - col1.x) - (col1.x - col4.x);
  float fyy = (col3.x - col1.x) - (col1.x - col5.x);
  float fxy = (col6.x - col3.x) - (col2.x - col1.x);

  fx /= dist;
  fy /= dist;
  fxx /= dist * dist;
  fxy /= dist * dist;
  fyy /= dist * dist;

  float k = ( fxx * fy*fy - 2.0 * fx*fy*fxy + fyy* fx* fx ) / ( fx*fx + fy*fy );
  // gl_FragColor = 15.0*vec4( fxx*fy*fy + -2.0 * fx*fy*fxy + fyy*fx*fx,0.0,0.0,1.0 );
  gl_FragColor = 2.0 * dist*dist*vec4( k,-k,0,1.0);
  //gl_FragColor = vec4(col1 +vec3(0.00001,0.001,0.000001)*k,1.0);
}
