uniform sampler2D frontcoordinates;
varying vec2 texcoord;
uniform float dist;

const float pointcnt = 400.0;


float sqr(float f)
{
  return f*f;
}

float geta( vec2 basepointlocationC, float dx, float dy, vec3 colmask )
{
  vec2 pointlocationC = basepointlocationC + vec2( dx,dy) / pointcnt;
  vec3 colC = texture2D( frontcoordinates, pointlocationC ).rgb;
  float distC = length(texcoord - pointlocationC) * pointcnt;
  float intensityC = dot( colmask, colC ); // 0.333* (colC.r + colC.g + colC.b );

  // perhaps take the sqrt of the intensity here to make up for the radial area
  intensityC = pow( intensityC, 1.4 );
  float dif =  (distC - intensityC / sqrt(3.0));
  //return dif < 0.0 ? 0.0 : 1.0;
  return clamp( dif * 8.0 + 0.5, 0.0, 1.0 ); // that 8 here is the antialiasing tweakfactor
}

float getColor( mat2 m, mat2 minverse, vec3 colmask )
{
  vec2 o = vec2( 0.5 + texcoord.x * pointcnt, 0.5 + texcoord.y * pointcnt );
  o *= m;
  vec2 basepointlocationC = vec2( floor( o.x  ) / pointcnt, floor( o.y ) / pointcnt );
  basepointlocationC *= minverse;

  vec2 dvecx = vec2(1.0,0.0) * minverse;
  vec2 dvecy = vec2(0.0,1.0) * minverse;

  float a = 1.0;
  
  a = geta(basepointlocationC, 0.0,0.0, colmask) * 
    geta(basepointlocationC, dvecx.x,dvecx.y, colmask) * 
    geta(basepointlocationC, -dvecx.x,-dvecx.y, colmask) * 
    geta(basepointlocationC, -dvecy.x,-dvecy.y, colmask) * 
    geta(basepointlocationC, dvecy.x,dvecy.y, colmask);

  return 1.0 - a;
}

void main()
{
/*
  mat2 Rm = mat2(  0.86119,  -0.25836 ,   0.00000 ,  0.86119 );
  mat2 Rminverse = mat2(    1.16119,  0.34836,  0.00000 , 1.16119 );

  mat2 Gm = mat2( 0.78078 , 0.39039,  0.00000 , 0.78078 );
  mat2 Gminverse = mat2( 1.28078 , -0.64039,   0.00000 ,   1.28078 );

  mat2 Bm = mat2(   0.32573 , 0.48859 ,  0.16286 , 0.81432 );
  mat2 Bminverse = mat2( 4.38575,  -2.63145,  -0.87715 ,  1.75430 );
*/


//  mat2 Rm = mat2( 1.0, 0.3, -0.3 , 1.0 );
//  mat2 Rminverse = mat2( 1.0, -0.3, 0.3 , 1.0 );

  mat2 Rm = mat2(  0.95783  , 0.28735,   -0.28735 ,  0.95783 );
  mat2 Rminverse = mat2(   0.95783 , -0.28735,   0.28735  , 0.95783 );


  mat2 Gm = mat2( 1.0, 0.0, 0.3 , 1.0 );
  mat2 Gminverse = mat2( 1.0, 0.0, -0.3 , 1.0 );

  mat2 Bm = mat2( 1.0, -0.5, 0.0 , 1.0 );
  mat2 Bminverse = mat2( 1.0, 0.5, 0.0 , 1.0 );

  vec3 color = vec3(0.0,0.0,0.0);
//  color.r = getColor( Rm, Rminverse, vec3(1.0,0.0,0.0) );
//  color.g = getColor( Gm, Gminverse, vec3(0.0,1.0,0.0) );
  color.b = getColor( Bm, Bminverse, vec3(0.0,0.0,1.0) );
  gl_FragColor = vec4( color,1.0 );
  //gl_FragColor = vec4(col1 +vec3(0.00001,0.001,0.000001)*k,1.0);
}

