# modelloader.py

"""Example of loading 3DS models.

Provides functions to load a 3DS model and creating a GLModel (or
BasicModel) from it. Shows how to load models from the filesystem, or
directly from a zip file.

"""


from Dice3DS.example import gltexture, glmodel


def load_model_from_filesystem(filename,modelclass=glmodel.GLModel,
			       texture_options=(),):
	"""Load a model from the filesystem.

	    model = load_model_from_filesystem(filename,
	                modelclass=glmodel.GLModel,
			texture_options=())

        This loads a model, where the textures are to be found in the
        filesystem.  filename is the 3DS file to load.  Any textures
        listed in it are expected to be found relative to the current
        directory.

	It creates a model of the given class, and creates textures
        with the given texture options.

	"""

	texcache = {}
	def load_texture(texfilename):
		if texcache.has_key(texfilename):
			return texcache[texfilename]
		tex = gltexture.Texture(texfilename,*texture_options)
		texcache[texfilename] = tex
		return tex
	
	dom = dom3ds.read_3ds_file(filename)
	return modelclass(dom,load_texture)


def load_model_from_zipfile(zipname,arcname,texargs=()):
	"""Load a model from a zipfile.

	    model = load_model_from_filesystem(zipfilename,
	                archivename, modelclass=glmodel.GLModel,
		        texture_options=())

        This loads a model, where the 3DS file and the textures are
        found inside a zipfile.  zipfilename is the name of the
        zipfile.  arcfilename is the name of the 3DS file inside the
        zipfile archive.  Any textures listed in it are expected to be
        found inside the zipfile as well.

	It creates a model of the given class, and creates textures
        with the given texture options.

	"""

	import cStringIO
	import zipfile

	texcache = {}
	def load_texture(texarchivename):
		if texcache.has_key(texarchivename):
			return texcache[texarchivename]
		flo = cStringIO.StringIO(zfo.read(texarchivename))
		tex = gltexture.Texture(flo,*texture_options)
		texcache[texarchivename] = tex
		return tex
	
	zfo = ZipFile(zipname,"r")
	try:
		dom = dom3ds.read_3ds_mem(zfo.read(arcname))
		return modelclass(dom,load_texture)
	finally:
		zfo.close()

