from cgtypes import vec3


class Camera:

    def __init__(self):
        self._fov = 85
        self._up = vec3(0, 1, 0)
        self._from = vec3(0, 0, 10)
        self._to = vec3(0, 0, 0)
        self._near = .1
        self._far = 150.0

    # ______________________

    def setNear(self, near):
        self._near = near

    def getNear(self):
        return self._near

    def setFar(self, far):
        self._far = far

    def getFar(self):
        return self._far

    def getUp(self):
        return self._up

    def setUp(self, up):
        self._up = up

    def setFrom(self, fro):
        self._from = fro

    def getFrom(self):
        return self._from 

    def setTo(self, to):
        self._to = to

    def getTo(self):
        return self._to

    def setFov(self, fov):
        self._fov = fov

    def getFov(self):
        return self._fov
    
    # _________________

    def pushGL(self):
        glMatrixMode(GL_PROJECTION)
        glLoadIdentity()
        gluPerspective(self.fov, 1.333, self._near, self._far)


        glMatrixMode(GL_MODELVIEW)
        glLoadIdentity()
        args = self._from.toList() + self._to.toList() + self._up.toList()
        gluLookAt(*args)
        
        
