#include <cstdlib>
// a really simple convertor for premultiplied alpha to normal alpha

void convert(char *dat, size_t width, size_t height) {

  unsigned char *data = (unsigned char*) dat;
  size_t s = width * height;
  size_t off = 0;
  for (size_t i = 0; i < s; ++i) {
    
    float alpha = data[off+3]/255.0;
    float inv = 0;
    if (alpha > 0) 
      inv = 1.0 / alpha;
    
    float r = data[off] * inv;
    if (r > 255)
      r = 255;
    data[off] = (unsigned char)r;

    float g = data[off+1] * inv;
    if (g > 255)
      g = 255;
    data[off+1] = (unsigned char)g;

    float b = data[off+2] * inv;
    if (b > 255)
      b = 255;
    data[off+2] = (unsigned char)b;
    off+=4;
  }
}
