; marvin@pseudohacker.org
;
(defun demo-init-clear()
  "Create demo-clear-str, which is used to clear the screen"
  (message "demo: initializing...")
  (setq demo-clear-str "")
  (let ((end (* (window-height) (window-width)))(pos 1))
    (while (> end 0)
      (if (= pos (window-width))
	  (setq demo-clear-str (concat demo-clear-str "\n"))
	(setq demo-clear-str (concat demo-clear-str " ")))
      (if (= pos (window-width))
	  (setq pos 0))
      (setq end (- end 1))
      (setq pos (+ pos 1))))
  (setq demo-clear-str (concat demo-clear-str "\n")))

(defun demo-clear ()
  "Use demo-clear-str to clear the screen"
  (message "demo: drawing blank screen")
  (erase-buffer)
  (insert demo-clear-str))

(defun demo-init()
  "Init clear string and clear the screen"
  (demo-init-clear)
  (demo-clear))

(defun demo-gotoxy(x y)
  (goto-char (+ (* (+ (window-width) 0) y) x 1)))

(defun demo-putpixel(x y c)
  "Put a ascii-pixel on the screen, what the hell did you think?"
  (goto-char (+ (* (+ (window-width) 0) y) x 1))
  (delete-char 1)
  (insert c))

(defun demo-line-majorY(x0 y0 x1 y1 c)
  (let ((i y0) (cx x0) (d 0) (dx 0) (dy 0))
    (setq dx (- x1 x0 0.0))
    (setq dy (- y1 y0 0.0))
    (setq d (/ dx dy))
    (while (< i y1)
      (demo-putpixel (round cx) (round i) c)
      (setq i (+ i 1))
      (setq cx (+ cx d)))))
(defun demo-line-majorX(x0 y0 x1 y1 c)
  (let ((i x0) (cy y0) (d 0) (dx 0) (dy 0))
    (setq dx (- x1 x0 0.0))
    (setq dy (- y1 y0 0.0))
    (setq d (/ dy dx))
    (while (< i x1)
      (demo-putpixel (round i) (round cy) c)
      (setq i (+ i 1))
      (setq cy (+ cy d)))))

(defun demo-line(x0 y0 x1 y1 c)
  "Draw a line in ascii"
  (if (> (abs (- x1 x0)) (abs (- y1 y0)))
      (if (> x0 x1)
	  (demo-line-majorX x1 y1 x0 y0 c)
	(demo-line-majorX x0 y0 x1 y1 c))
    (if (> y0 y1)
	(demo-line-majorY x1 y1 x0 y0 c)
      (demo-line-majorY x0 y0 x1 y1 c))))

(defun demo-putimage(x y inimg)
  "Splash ascii image"
  (setq img inimg)
  (while (setq foo (car img))
    (demo-gotoxy x y)
    (setq img (cdr img))
    (delete-char (length foo))
    (insert foo)
    (setq y (+ y 1))))
