
varying vec4 screenpos;
varying vec3 pos;
varying vec3 normal;
varying vec3 color;


#vertexshader

void main()
{
	gl_Position = ftransform();
	//normal = gl_Normal;
	normal = gl_NormalMatrix * gl_Normal;
	pos = gl_Vertex.xyz;//*gl_ModelViewMatrix).xyz;
	screenpos = gl_Position;
	color = gl_Color.xyz;
}

#fragmentshader

uniform vec3 lightpos0;
uniform vec3 lightpos1;

void main()
{
	vec3 fogcolor = vec3(0.9,0.9,0.9);
	vec3 out_color = vec3(0.0);

	float lightranges[2] = {200.0, 200.0};
	float fogdistance = 300.0;
	float lightintens[2] = {2.0, 3.5};

	for(int i = 0; i < 2; i++)
	{
		vec3 lightpos;

		if(i == 0)
			lightpos = lightpos0;
		else
			lightpos = lightpos1;
		vec3 delta = lightpos-pos.xyz;

		vec3 lightdir = normalize(delta);
		//float dist = clamp(1.0-length(delta)/1000.0, 0.0, 1.0);
		float d = 0.25+(dot(lightdir, normal)+1.0) / 4.0;
		//float d = 1.0 - 1200.0/length(lightpos-pos.xyz);
		//d = 1-dist;
		float dist = clamp(1.0-length(delta)/lightranges[i],0.0,1.0);
		dist = pow(dist, 0.4);
		//if( < 75.0)
		//	dist = 1.0;

		out_color += color*(dist*d)*lightintens[i];
	}

	// apply fog
	float f = length(screenpos);
	float distfactor = clamp(length(screenpos)-100.0,0.0,fogdistance)/fogdistance;
	out_color = mix(out_color, fogcolor, pow(distfactor, 3.0));

	gl_FragColor = vec4(out_color,1.0);
	//gl_FragColor = vec4(color,1.0);
}
