using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace StarifficEditor
{
    public class LevelGrid
    {
        public float grid_slot_size = 30.0f;
        public float grid_x, grid_y;
        public int grid_w, grid_h;

        public List< LevelObject >[,] grid;

        public LevelGrid(Level level)
        {
            RectangleF bbox = level.BoundingBox;

            grid_x = bbox.Left;
            grid_y = bbox.Top;
            grid_w = 1 + (int)(bbox.Width / grid_slot_size);
            grid_h = 1 + (int)(bbox.Height / grid_slot_size);

            // Create the empty list
            grid = new List< LevelObject >[ grid_w, grid_h ];
            for (int y = 0; y < grid_h; ++y)
                for (int x = 0; x < grid_w; ++x)
                    grid[x, y] = new List<LevelObject>();

            // Add each object
            foreach (LevelObject obj in level.objects)
                AddObject(obj);
        }

        private void AddObject(LevelObject obj)
        {
            if (!obj.IsStatic)
                return;

            RectangleF bbox = obj.BoundingBox;
            int gx = (int)((bbox.Left - grid_x) / grid_slot_size);
            int gy = (int)((bbox.Top - grid_y) / grid_slot_size);

            float cur_y = grid_y + gy * grid_slot_size;
            for ( ; cur_y  < bbox.Bottom; ++gy, cur_y += grid_slot_size )
            {
                float cur_x = grid_x + gx * grid_slot_size;
                int idx = gx;
                for ( ; cur_x  < bbox.Right; ++idx, cur_x += grid_slot_size )
                {
                    grid[ idx, gy ].Add( obj );
                }
            }
        }
    }
}
