import javax.microedition.lcdui.*;

/**
 * Misc utils.
 */
public final class MiscUtils
{
    public static void writeShadowed( Graphics g, String txt, int x, int y )
    {
        int c = g.getColor();
        
        g.setColor( 0xff000000 );
        g.drawString( txt, x + 2, y + 2, Graphics.TOP | Graphics.LEFT );
        
        g.setColor( c );
        g.drawString( txt, x, y, Graphics.TOP | Graphics.LEFT );
    }
    
    /**
     * Writes the given text cetered to the screen.
     * 
     * @param g
     * @param txt
     * @param y
     * @param scr_w
     */
    public static void writeCentered( Graphics g, String txt, int y, int scr_w )
    {
        Font f = g.getFont();
        int text_w = f.stringWidth( txt );
        
        writeShadowed( g, txt, (scr_w-text_w)/2, y );
    }

    
    /**
     * Converts a second time (FP) to a string.
     * 
     * @param time_secs The time in fixed point seconds.
     * @return The time string.
     */
    public static String timeToString( int time_secs )
    {
        g_sb.setLength( 0 );
        
        int time1 = FP.toInt(time_secs);
        if (time1 <= 9) g_sb.append('0');
        g_sb.append(time1);

        g_sb.append(':');
        
        int time2 = FP.toInt((time_secs&0xffff)*100);
        if (time2 <= 9) g_sb.append('0');
        g_sb.append(time2);
        
        return g_sb.toString();
    }
    
    private MiscUtils()
    { }
    
    private static StringBuffer g_sb = new StringBuffer(); 
}
