import java.io.*;

/**
 * Mesh list.
 */
public class Meshes
{
    public Mesh[] meshes;
    
    public Meshes()
    {
        if (Res.editor_mesh_data != null)
            init(Res.editor_mesh_data);
        else
            init("/msh");
    }
    
    /**
     * Finds a mesh by id.
     * 
     * @param id The mesh id.
     * @return The mesh or null.
     */
    public Mesh find( int id )
    {
        for ( int i = 0; i < meshes.length; ++i )
        {
            if (meshes[i].id == id)
                return meshes[i];
        }
        
        return null;
    }
    
    /**
     * Finds a mesh by name.
     * 
     * @param name The mesh name.
     * @return The mesh or null.
     */
    public Mesh find( String name )
    {
        for ( int i = 0; i < meshes.length; ++i )
        {
            if (name.equals(meshes[i].name))
                return meshes[i];
        }
        
        return null;
    }
    
    /**
     * Initializes from the given data.
     * 
     * @param data The raw data.
     */
    private void init(byte[] data)
    {
        try
        {
            InputStream in = new ByteArrayInputStream(data);
            init(new DataInputStream(in));
            in.close();
        }
        catch (Throwable t)
        {
            throw new Error("Error loading the meshes: " + t);
        }
    }
    
    /**
     * Initializes from the given file.
     * 
     * @param fname The file resource name.
     */
    private void init(String fname)
    {
        try
        {
            InputStream in = Res.getResourceAsStream(fname);
            init(new DataInputStream(in));
            in.close();
        }
        catch (Throwable t)
        {
            throw new Error("Error loading the meshes: " + t);
        }
    }
    
    /**
     * Inits from the given stream.
     * 
     * @param in The data stream.
     * @throws IOException
     */
    private void init(DataInputStream in) throws IOException
    {
        int amt = in.readShort();
        
        meshes = new Mesh[amt];
        for ( int i = 0; i < amt; ++i )
        {
            Mesh m = new Mesh();
            meshes[ i ] = m;
            
            // Read the mesh
            m.id = in.readInt();
            m.name = in.readUTF();
            
            int points = in.readShort();
            m.point_data = new int[ points * 2 ];
            m.point_temp = new int[ points * 2 ];
            for ( int j = 0; j < points; ++j )
            {
                m.point_data[ j * 2 + 0 ] = in.readInt();
                m.point_data[ j * 2 + 1 ] = in.readInt();
            }

            int faces = in.readShort();
            m.face_data = new int[ faces * 4 ];
            for ( int j = 0; j < faces; ++j )
            {
                m.face_data[ j * 4 + 0 ] = in.readInt();
                m.face_data[ j * 4 + 1 ] = in.readShort();
                m.face_data[ j * 4 + 2 ] = in.readShort();
                m.face_data[ j * 4 + 3 ] = in.readShort();
            }
        }
    }
}
