////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.*;

/** 
 * Screen canvas class.
 */
public class ScreenCanvas extends Canvas
{
    private Image m_backbuffer;
    
    private Screen m_cur_screen;
    private Screen m_next_screen;
    
    public ScreenCanvas()
    {
        // Get the start
        if (Res.pc_mode && Res.editor_level_data != null)
            m_cur_screen = new GameScreen( "/1", 0 );
        else
            m_cur_screen = new SoundMenuScreen();
        setFullScreenMode( true );
    }
    
    /**
     * Updates the current screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public void updateFrame( int fp_secs )
    {
        // Need a screen flip?
        if ( m_next_screen != null )
        {
            m_cur_screen = m_next_screen;
            m_next_screen = null;
        }
        
        // Update the screen
        Screen scr = m_cur_screen.updateFrame( fp_secs );
        if ( scr == null || scr == m_cur_screen )
            return;
        m_next_screen = scr;
    }
    
    /**
     * The MIDlet paint method.
     */
    public void paint( Graphics g )
    {
        int scr_w = getWidth();
        int scr_h = getHeight();
        
        if ( m_backbuffer == null ||
             m_backbuffer.getWidth() != scr_w ||
             m_backbuffer.getHeight() != scr_h )
        {
            m_backbuffer = Image.createImage( scr_w, scr_h );
        }
        
        if (m_cur_screen != null)
            m_cur_screen.render( m_backbuffer.getGraphics(), scr_w, scr_h );
        
        g.drawImage( m_backbuffer, 0, 0, Graphics.TOP | Graphics.LEFT );
    }
    
    public void keyPressed( int key )
    {
        if (m_cur_screen != null)
            m_cur_screen.keyPressed( key, getGameAction( key ) );
    }
    
}
