////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.media.*;
import java.io.*;

/**
 * Audio functionality.
 */
public class Audio
{
    public Player music_menu;
    public Player music_game;
    public Player music_game2;
    
    public Player sound_die;
    public Player sound_win;
    public Player sound_bump;
    public Player sound_grav;
    public Player sound_item;
    
    private Player m_cur_music;
    
    /**
     * Inits the audio system.
     * It can be used before initializing, but nothing will happen.
     */
    public void init()
    {
        music_menu = loadSound( "/m.mid", "audio/midi" );
        music_game = loadSound( "/g.mid", "audio/midi" );
        music_game2 = loadSound( "/g2.mid", "audio/midi" );
        
        if ( Res.pc_mode )
        {
            sound_die = loadSound( "/die.au", "audio/basic" );
            sound_win = loadSound( "/win.au", "audio/basic" );
            sound_bump = loadSound( "/bump.au", "audio/basic" );
            sound_grav = loadSound( "/grav.au", "audio/basic" );
            sound_item = loadSound( "/win.au", "audio/basic" );
        }
    }
    
    /**
     * Plays a sound
     *  
     * @param plr The sound to play.
     */
    public void playSound( Player plr )
    {
        if ( plr == null )
            return;
        try
        {
            plr.stop();
            plr.setMediaTime( 0 );
            plr.start();
        }
        catch ( Throwable t )
        {
        }
    }
    
    /**
     * Starts to play a music.
     *  
     * @param plr The music to play.
     */
    public void playMusic( Player plr )
    {
        // Already playing?
        if ( m_cur_music == plr )
            return;
        
        // Stop current
        if ( m_cur_music != null )
        {
            try
            { 
                m_cur_music.stop();
            }
            catch ( Throwable t )
            {
                System.out.println( "Error stopping music:" );
                t.printStackTrace();
            }
            m_cur_music = null;
        }
        
        // Switch to new
        m_cur_music = plr;
        
        // Start to play
        if ( m_cur_music != null )
        {
            try
            { 
                m_cur_music.setMediaTime( 0 );
                m_cur_music.setLoopCount( -1 );
                m_cur_music.start();
            }
            catch ( Throwable t )
            {
                System.out.println( "Error starting music:" );
                t.printStackTrace();
            }
        }
    }
    
    /**
     * Loads the given sound resource.
     * 
     * @param name The name of the file to load.
     * @param mime_type The mime type of the sound.
     * @return The music player.
     */
    private Player loadSound( String name, String mime_type )
    {
        try
        {
            Player ret = null;
            
            if ( Res.pc_mode )
            {
                ret = Manager.createPlayer( name );
                if ( ret == null )
                    return null;
                ret.realize();
                ret.prefetch();
            }
            else
            {
                // Open the resource
                InputStream in = Res.getResourceAsStream( name );
                if ( in == null )
                    return null;
                
                // Load it
                ret = Manager.createPlayer( in, mime_type );
                if ( ret == null )
                    return null;
                ret.realize();
                ret.prefetch();
                try { in.close(); } catch ( Throwable t ) { }
            }
            
            return ret;
        }
        catch ( Throwable t )
        {
            System.out.println("Error loading music:");
            t.printStackTrace();
            return null;
        }
    }
}
